/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand;

import com.atlassian.plugins.rest.common.expand.DefaultExpandContext;
import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.Expandable;
import com.atlassian.plugins.rest.common.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.common.util.ReflectionUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCrawler {
    public void crawl(Object entity, ExpandParameter expandParameter, EntityExpanderResolver expanderResolver) {
        if (entity == null) {
            return;
        }
        Collection<Field> expandableFields = this.getExpandableFields(entity);
        this.setExpandParameter(expandableFields, entity);
        this.expandFields(expandableFields, entity, expandParameter, expanderResolver);
    }

    private void setExpandParameter(Collection<Field> expandableFields, Object entity) {
        Field expand = this.getExpandField(entity);
        if (expand != null && !expandableFields.isEmpty()) {
            StringBuilder expandValue = new StringBuilder();
            for (Field field : expandableFields) {
                expandValue.append(this.getExpandable(field).value()).append(",");
            }
            expandValue.deleteCharAt(expandValue.length() - 1);
            ReflectionUtils.setFieldValue(expand, entity, expandValue.toString());
        }
    }

    private Field getExpandField(Object entity) {
        for (Field field : ReflectionUtils.getDeclaredFields(entity.getClass())) {
            XmlAttribute annotation;
            if (!field.getType().equals(String.class) || (annotation = field.getAnnotation(XmlAttribute.class)) == null || !field.getName().equals("expand") && !"expand".equals(annotation.name())) continue;
            return field;
        }
        return null;
    }

    private Collection<Field> getExpandableFields(final Object entity) {
        return Collections2.filter(ReflectionUtils.getDeclaredFields(entity.getClass()), (Predicate)new Predicate<Field>(){

            public boolean apply(Field field) {
                return EntityCrawler.this.getExpandable(field) != null && ReflectionUtils.getFieldValue(field, entity) != null;
            }
        });
    }

    private void expandFields(Collection<Field> expandableFields, Object entity, ExpandParameter expandParameter, EntityExpanderResolver expanderResolver) {
        for (Field field : expandableFields) {
            Expandable expandable = this.getExpandable(field);
            if (!expandParameter.shouldExpand(expandable) || !expanderResolver.hasExpander(field.getType())) continue;
            EntityExpander<?> entityExpander = expanderResolver.getExpander(field.getType());
            DefaultExpandContext<Object> context = new DefaultExpandContext<Object>(ReflectionUtils.getFieldValue(field, entity), expandable, expandParameter);
            ReflectionUtils.setFieldValue(field, entity, entityExpander.expand(context, expanderResolver, this));
        }
    }

    Expandable getExpandable(Field field) {
        if (field == null) {
            return null;
        }
        Expandable expandable = field.getAnnotation(Expandable.class);
        if (expandable == null) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)expandable.value())) {
            return expandable;
        }
        XmlElement xmlElement = field.getAnnotation(XmlElement.class);
        if (xmlElement != null && StringUtils.isNotEmpty((String)xmlElement.name()) && !StringUtils.equals((String)"##default", (String)xmlElement.name())) {
            return new ExpandableWithValue(xmlElement.name());
        }
        return new ExpandableWithValue(field.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpandableWithValue
    implements Expandable {
        private final String value;

        public ExpandableWithValue(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Expandable.class;
        }
    }
}

