package com.atlassian.plugins.rest.common.json;

import com.sun.jersey.api.json.JSONJAXBContext;

/**
 * Factory responsible for creating a JSONJAXBContext used for marshalling and un-marshalling JAXB beans to JSON.
 *
 * @since v1.0.2
 */
public interface JsonJaxbContextFactory
{

    /**
     * Given a list of JAXB classes, this method creates a JSONJAXBContext
     *
     * @param classes a list of JAXB classes
     * @return a JSONJAXBContext
     */
    JSONJAXBContext createContext(Class... classes);
}
