/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand.resolver;

import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.google.common.base.Preconditions;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingEntityExpanderResolver
implements EntityExpanderResolver {
    private final List<EntityExpanderResolver> resolvers;

    public ChainingEntityExpanderResolver(List<EntityExpanderResolver> resolvers) {
        for (EntityExpanderResolver resolver : (List)Preconditions.checkNotNull(resolvers)) {
            if (resolver != null) continue;
            throw new NullPointerException("Resolver items cannot be null!");
        }
        this.resolvers = resolvers;
    }

    public boolean hasExpander(Object instance) {
        return this.hasExpander(Preconditions.checkNotNull((Object)instance).getClass());
    }

    @Override
    public boolean hasExpander(Class<?> type) {
        Preconditions.checkNotNull(type);
        for (EntityExpanderResolver resolver : this.resolvers) {
            if (!resolver.hasExpander(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> EntityExpander<T> getExpander(T instance) {
        return this.getExpander(instance.getClass());
    }

    @Override
    public <T> EntityExpander<T> getExpander(Class<? extends T> type) {
        for (EntityExpanderResolver resolver : this.resolvers) {
            EntityExpander<? extends T> expander = resolver.getExpander(type);
            if (expander == null) continue;
            return expander;
        }
        return null;
    }
}

