/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.multipart.fileupload;

import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartHandler;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsFileUploadMultipartHandler
implements MultipartHandler {
    private final ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());

    public CommonsFileUploadMultipartHandler(long maxFileSize) {
        this.servletFileUpload.setFileSizeMax(maxFileSize);
    }

    @Override
    public FilePart getFilePart(HttpServletRequest request, String field) {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            throw new RuntimeException("Not a multipart request");
        }
        try {
            for (FileItem item : this.getFileItems(request)) {
                if (!item.getFieldName().equals(field)) continue;
                return new CommonsFileUploadFilePart(item);
            }
            throw new RuntimeException("balsdjlas");
        }
        catch (FileUploadException e) {
            throw new RuntimeException(e);
        }
    }

    private List<FileItem> getFileItems(HttpServletRequest request) throws FileUploadException {
        return this.servletFileUpload.parseRequest(request);
    }

    private static class CommonsFileUploadFilePart
    implements FilePart {
        private final FileItem fileItem;

        CommonsFileUploadFilePart(FileItem fileItem) {
            this.fileItem = (FileItem)Preconditions.checkNotNull((Object)fileItem);
        }

        public String getName() {
            return this.fileItem.getName();
        }

        public InputStream getInputStream() throws IOException {
            return this.fileItem.getInputStream();
        }
    }
}

