/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand;

import com.atlassian.plugins.rest.common.expand.DefaultExpandContext;
import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.Expandable;
import com.atlassian.plugins.rest.common.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.common.util.ReflectionUtils;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityCrawler {
    public void crawl(Object entity, ExpandParameter expandParameter, EntityExpanderResolver expanderResolver) {
        if (entity == null) {
            return;
        }
        Collection<Field> expandableFields = this.getExpandableFields(entity);
        this.setExpandParameter(expandableFields, entity);
        this.expandFields(expandableFields, entity, expandParameter, expanderResolver);
    }

    private void setExpandParameter(Collection<Field> expandableFields, Object entity) {
        Field expand = this.getExpandField(entity);
        if (expand != null && !expandableFields.isEmpty()) {
            StringBuilder expandValue = new StringBuilder();
            for (Field field : expandableFields) {
                expandValue.append(this.getExpandable(field).value()).append(",");
            }
            expandValue.deleteCharAt(expandValue.length() - 1);
            ReflectionUtils.setFieldValue(expand, entity, expandValue.toString());
        }
    }

    private Field getExpandField(Object entity) {
        for (Field field : entity.getClass().getDeclaredFields()) {
            XmlAttribute annotation;
            if (!field.getType().equals(String.class) || (annotation = field.getAnnotation(XmlAttribute.class)) == null || !field.getName().equals("expand") && !"expand".equals(annotation.name())) continue;
            return field;
        }
        return null;
    }

    private Collection<Field> getExpandableFields(Object entity) {
        LinkedList expandableFields = Lists.newLinkedList();
        for (Field field : entity.getClass().getDeclaredFields()) {
            if (this.getExpandable(field) == null) continue;
            expandableFields.add(field);
        }
        return expandableFields;
    }

    private void expandFields(Collection<Field> expandableFields, Object entity, ExpandParameter expandParameter, EntityExpanderResolver expanderResolver) {
        for (Field field : expandableFields) {
            Expandable expandable = this.getExpandable(field);
            if (!expandParameter.shouldExpand(expandable)) continue;
            EntityExpander<?> entityExpander = expanderResolver.getExpander(field.getType());
            DefaultExpandContext<Object> context = new DefaultExpandContext<Object>(ReflectionUtils.getFieldValue(field, entity), expandable, expandParameter);
            ReflectionUtils.setFieldValue(field, entity, entityExpander.expand(context, expanderResolver, this));
        }
    }

    private Expandable getExpandable(Field field) {
        Expandable expandable = field.getAnnotation(Expandable.class);
        if (expandable == null) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)expandable.value())) {
            return expandable;
        }
        String xmlElementName = field.getAnnotation(XmlElement.class).name();
        if (StringUtils.isNotEmpty((String)xmlElementName) && !StringUtils.equals((String)"##default", (String)xmlElementName)) {
            return new ExpandableWithValue(xmlElementName);
        }
        return new ExpandableWithValue(field.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpandableWithValue
    implements Expandable {
        private final String value;

        public ExpandableWithValue(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Expandable.class;
        }
    }
}

