package com.atlassian.plugins.utils;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ReflectionHelper {

    private static VarHandle modifiersField;

    public static void makeNonFinalJre11AndHigher(Field field) throws IllegalAccessException, NoSuchFieldException {
        if (modifiersField == null) {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Field.class, MethodHandles.lookup());
            modifiersField = lookup.findVarHandle(Field.class, "modifiers", int.class);
        }

        int modifiers = field.getModifiers();
        if (Modifier.isFinal(modifiers)) {
            modifiersField.set(field, modifiers & ~Modifier.FINAL);
        }
    }

}
