package com.atlassian.plugins.license.service;

import com.atlassian.plugins.license.entity.LicenseTierInfoEntity;
import com.atlassian.plugins.license.exception.InvalidDataVersionException;
import com.atlassian.plugins.license.model.LicenseDataVersion;
import com.atlassian.plugins.license.model.LicensedUser;
import com.atlassian.plugins.license.model.UserDirectoryInformation;

import java.util.Collection;
import java.util.List;
import java.util.Optional;

public interface LicenseUsageService {
    List<LicensedUser> getLicensedUsers(Long version, int start, int limit) throws InvalidDataVersionException;

    void saveDirectoryInfo(Collection<UserDirectoryInformation> directoryInformation);

    List<UserDirectoryInformation> getDirectoryInfo(Long version, int start, int limit) throws InvalidDataVersionException;

    void clearStaleLicenseDataIfAny();

    void markVersionComplete(Long version);

    LicenseDataVersion createLicenseDataVersion();

    Optional<LicenseDataVersion> getLatestValidVersion();

    void saveLicensedUserInformation(LicensedUser licensedUser);

    void saveLicensedUsersInformation(Collection<? extends LicensedUser> licensedUsers);

    List<LicenseTierInfoEntity> getLicenseTierInformation();

    void clearLicenseData();
}
