package com.atlassian.plugins.license.entity;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Objects;
import java.util.StringJoiner;

public class LicenseTierInfoEntity {

    @JsonProperty("applicationKey")
    private String applicationKey;

    @JsonProperty("maximumNumberOfUsers")
    private long maximumNumberOfUsers;

    @JsonProperty("licenseExpiryDate")
    private Long licenseExpiryDate;

    @JsonProperty("applicationDisplayName")
    private String applicationDisplayName;

// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    @JsonCreator
    public LicenseTierInfoEntity(@JsonProperty("applicationKey") String applicationKey, @JsonProperty("maximumNumberOfUsers") long maximumNumberOfUsers,
                                    @JsonProperty("licenseExpiryDate") Long licenseExpiryDate, @JsonProperty("applicationDisplayName") String applicationDisplayName) {
        this.applicationKey = applicationKey;
        this.maximumNumberOfUsers = maximumNumberOfUsers;
        this.licenseExpiryDate = licenseExpiryDate;
        this.applicationDisplayName = applicationDisplayName;
    }

    public String getApplicationKey() {
        return applicationKey;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public long getMaximumNumberOfUsers() {
        return maximumNumberOfUsers;
    }

    public void setMaximumNumberOfUsers(long maximumNumberOfUsers) {
        this.maximumNumberOfUsers = maximumNumberOfUsers;
    }

    public Long getLicenseExpiryDate() {
        return licenseExpiryDate;
    }

    public void setLicenseExpiryDate(Long licenseExpiryDate) {
        this.licenseExpiryDate = licenseExpiryDate;
    }

    public String getApplicationDisplayName() {
        return applicationDisplayName;
    }

    public void setApplicationDisplayName(String applicationDisplayName) {
        this.applicationDisplayName = applicationDisplayName;
    }

    public static LicenseTierInfoEntity.Builder builder() {
        return new LicenseTierInfoEntity.Builder();
    }

    public static LicenseTierInfoEntity.Builder builder(LicenseTierInfoEntity data) {
        return new LicenseTierInfoEntity.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        LicenseTierInfoEntity that = (LicenseTierInfoEntity) o;

        return Objects.equals(this.getApplicationKey(), that.getApplicationKey()) && Objects.equals(this.getMaximumNumberOfUsers(), that.getMaximumNumberOfUsers()) && Objects.equals(this.getLicenseExpiryDate(), that.getLicenseExpiryDate()) && Objects.equals(this.getApplicationDisplayName(), that.getApplicationDisplayName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getApplicationKey(), getMaximumNumberOfUsers(), getLicenseExpiryDate(), getApplicationDisplayName());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]")
                .add("applicationKey=" + getApplicationKey())
                .add("maximumNumberOfUsers=" + getMaximumNumberOfUsers())
                .add("licenseExpiryDate=" + getLicenseExpiryDate())
                .add("applicationDisplayName=" + getApplicationDisplayName())
                .toString();
    }

    public static final class Builder {

        private String applicationKey;
        private long maximumNumberOfUsers;
        private Long licenseExpiryDate;
        private String applicationDisplayName;

        private Builder() {
        }

        private Builder(LicenseTierInfoEntity initialData) {
            this.applicationKey = initialData.getApplicationKey();
            this.maximumNumberOfUsers = initialData.getMaximumNumberOfUsers();
            this.licenseExpiryDate = initialData.getLicenseExpiryDate();
            this.applicationDisplayName = initialData.getApplicationDisplayName();
        }

        public Builder setApplicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder setMaximumNumberOfUsers(long maximumNumberOfUsers) {
            this.maximumNumberOfUsers = maximumNumberOfUsers;
            return this;
        }

        public Builder setLicenseExpiryDate(Long licenseExpiryDate) {
            this.licenseExpiryDate = licenseExpiryDate;
            return this;
        }

        public Builder setApplicationDisplayName(String applicationDisplayName) {
            this.applicationDisplayName = applicationDisplayName;
            return this;
        }

        public LicenseTierInfoEntity build() {
            return new LicenseTierInfoEntity(applicationKey, maximumNumberOfUsers, licenseExpiryDate, applicationDisplayName);
        }
    }
}
