/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.util;

import com.atlassian.plugins.domain.DTO;
import com.atlassian.plugins.domain.model.Expand;
import com.atlassian.plugins.domain.model.review.ReviewSummary;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityUtils {
    public static final String ENTITY_TAG_NOT_POSSIBLE = "00";

    private EntityUtils() {
    }

    public static String getEntityTag(DTO dto) {
        Field[] flds;
        if (dto == null || dto.getId() == null) {
            return null;
        }
        HashCodeBuilder builder = new HashCodeBuilder(3, 23).append((Object)dto.getClass().getName()).append((Object)dto.getId());
        if (dto.getLastModified() != null) {
            builder.append((Object)dto.getLastModified());
        }
        for (Field field : flds = dto.getClass().getDeclaredFields()) {
            Expand ann = field.getAnnotation(Expand.class);
            if (ann == null) continue;
            field.setAccessible(true);
            try {
                ReviewSummary rs;
                Object value;
                Class<?> theClass = field.getType();
                String etag = null;
                if (theClass == ListWrapper.class) {
                    value = (ListWrapper)field.get(dto);
                    if (value != null) {
                        if (((ListWrapper)value).isEmpty()) {
                            Field setSizeField = ListWrapper.class.getDeclaredField("setSize");
                            setSizeField.setAccessible(true);
                            Integer size = (Integer)setSizeField.get(value);
                            if (size != null) {
                                etag = size.toString();
                            }
                        } else {
                            etag = EntityUtils.getEntityTag(((ListWrapper)value).getList(), null, null);
                        }
                    }
                } else if (theClass == DTO.class) {
                    value = (DTO)field.get(dto);
                    if (value != null && value.isExpanded()) {
                        etag = EntityUtils.getEntityTag((DTO)value);
                    }
                } else if (theClass == ReviewSummary.class && (rs = (ReviewSummary)field.get(dto)) != null) {
                    HashCodeBuilder rsBuilder = new HashCodeBuilder(79, 109).append((Object)ReviewSummary.class.getName());
                    if (rs.getAverage() != null) {
                        rsBuilder.append((Object)rs.getAverage());
                    }
                    if (rs.getTotal() != null) {
                        rsBuilder.append((Object)rs.getTotal());
                    }
                    etag = String.valueOf(rsBuilder.toHashCode());
                }
                if (etag == null) continue;
                builder.append(etag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return String.valueOf(builder.toHashCode());
    }

    public static String getEntityTag(List<? extends DTO> dtos, Integer max, Integer offset) {
        if (dtos == null || dtos.isEmpty()) {
            return ENTITY_TAG_NOT_POSSIBLE;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (DTO dTO : dtos) {
            String etag = EntityUtils.getEntityTag(dTO);
            if (etag == null) continue;
            ids.add(etag);
        }
        if (ids.isEmpty()) {
            return ENTITY_TAG_NOT_POSSIBLE;
        }
        if (ids.size() > 1) {
            Collections.sort(ids);
        }
        HashCodeBuilder builder = new HashCodeBuilder(37, 67).append((Object)((Object)ids).toString());
        if (max != null) {
            builder.append((Object)max);
        }
        if (offset != null) {
            builder.append((Object)offset);
        }
        return String.valueOf(builder.toHashCode());
    }
}

