package com.atlassian.plugins.util;

import com.atlassian.plugins.domain.DTO;
import com.atlassian.plugins.domain.model.Expand;
import com.atlassian.plugins.domain.model.review.ReviewSummary;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import org.apache.commons.lang.builder.HashCodeBuilder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SuppressWarnings("unchecked")
public class EntityUtils {

    private EntityUtils() {}

    public static final String ENTITY_TAG_NOT_POSSIBLE = "00";

    public static String getEntityTag(DTO dto) {

        if (dto == null || dto.getId() == null) return null;

        //first, build the hashcode for the class
        HashCodeBuilder builder = new HashCodeBuilder(3, 23)
            .append(dto.getClass().getName())
            .append(dto.getId());

        if (dto.getLastModified() != null) builder.append(dto.getLastModified());

        //now look for any expanded fields
        Field[] flds = dto.getClass().getDeclaredFields();
        for (Field field : flds) {

            // does the field have the Expand annotation?
            Annotation ann = field.getAnnotation(Expand.class);
            if (ann != null) {

                field.setAccessible(true);

                //get the entity tag for that DTO/Obj or ListWrapper if it's expanded
                try {

                    Class theClass = field.getType();
                    String etag = null;

                    if (theClass == ListWrapper.class) {
                        ListWrapper value = (ListWrapper)field.get(dto);
                        if (value != null) {
                            if (value.isEmpty()) {
                                //non null, but empty, get the size
                                Field setSizeField = ListWrapper.class.getDeclaredField("setSize");
                                setSizeField.setAccessible(true);
                                Integer size = (Integer)setSizeField.get(value);
                                if (size != null) {
                                    etag = size.toString();
                                }
                            } else {
                                //non null, non empty, get the etag for each element
                                etag = getEntityTag(value.getList(), null, null);
                            }
                        }

                    } else {

                        //grab the etag for the dto
                        if (theClass == DTO.class) {
                            DTO value = (DTO)field.get(dto);
                            if (value != null && value.isExpanded()) {
                                etag = getEntityTag(value);
                            }

                        //special case for review summary (it is not a DTO)
                        } else if (theClass == ReviewSummary.class) {
                            ReviewSummary rs = (ReviewSummary)field.get(dto);
                            if (rs != null) {

                                HashCodeBuilder rsBuilder = new HashCodeBuilder(79, 109).append(ReviewSummary.class.getName());
                                if (rs.getAverage() != null) rsBuilder.append(rs.getAverage());
                                if (rs.getTotal() != null) rsBuilder.append(rs.getTotal());

                                etag = String.valueOf(rsBuilder.toHashCode());
                                
                            }
                        }
                    }

                    if (etag != null) builder.append(etag);

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        return String.valueOf(builder.toHashCode());
    }

    public static String getEntityTag(List<? extends DTO> dtos, Integer max, Integer offset) {

        if (dtos == null || dtos.isEmpty()) return ENTITY_TAG_NOT_POSSIBLE;

        List<String> ids = new ArrayList<String>();

        for (DTO dto : dtos) {
            String etag = getEntityTag(dto);
            if (etag != null) ids.add(etag);
        }

        if (ids.isEmpty()) return ENTITY_TAG_NOT_POSSIBLE; 

        if (ids.size() > 1) Collections.sort(ids);

        HashCodeBuilder builder = new HashCodeBuilder(37, 67).append(ids.toString());
        if (max != null) builder.append(max);
        if (offset != null) builder.append(offset);

        return String.valueOf(builder.toHashCode());
        
    }

}
