package com.atlassian.plugins.util;

import java.util.Calendar;
import java.util.Date;

public class DateUtils {

    private DateUtils() {}

    public static Calendar getCalendar(Date date, boolean reset) {
        if (date == null) return null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (reset) resetTime(cal);
        return cal;
    }

    public static void resetTime(Calendar cal) {
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
    }

}
