package com.atlassian.plugins.service.product;

import com.atlassian.plugins.domain.model.product.CompatibilityMatrix;
import com.atlassian.plugins.domain.model.product.ProductCompatibility;
import com.atlassian.plugins.service.RestService;

import java.util.List;

/**
 * Provides REST services related to product compatibilities.
 */
public interface ProductCompatibilityService extends RestService<ProductCompatibility> {

    public static final String PATH = "/productcompatibility";

    public static final String PATH_MATRIX = "/matrix";

    /**
     * REST path to the plugin version upgrade service.
     */
    public static final String PATH_AUTOUPDATE = "/autoupdate";

    public static final String PARAM_REDUCE = "r";
    public static final String PARAM_VALUE_MATRIX_MAJOR = "major";
    public static final String PARAM_VALUE_MATRIX_MINOR = "minor";
    public static final String PARAM_VALUE_MATRIX_ALL = "*";

    /**
     * Parameter name for the product being passed to the plugin version upgrade service.
     */
    public static final String PARAM_CATEGORYID = "categoryId";

    public List<CompatibilityMatrix> findCompatibilityMatrix(String pluginId, String reductionType, List<String> expand);

    /**
     * Returns a list of product compatibilties considered compatible, and therefore
     * upgradeable, to the specified product.
     * @param categoryId ID of the product in the category table
     * @param expand a {@code List} of fields to automatically populate in the
     * returned domain objects
     * @return a {@code List} of compatible product compatibilities
     */
    public List<ProductCompatibility> getUpgradeablePluginVersions(String categoryId, List<String> expand);

    /**
     * Upgrades all product compatibilities considered compatible with the specified
     * product to be maximally compatible with the specified product.
     * @param toCategoryId ID of the product to upgrade to (from the category table)
     * @param expand a {@code List} of fields to automatically populate in the
     * returned domain objects
     * @return a {@code List} of successfully upgraded product compatibilities
     */
    public List<ProductCompatibility> upgradePluginVersions(String toCategoryId, List<String> expand);

}
