package com.atlassian.plugins.service;

import com.atlassian.plugins.domain.search.SearchCriteria;

import java.util.List;

public interface RestService<T> {

    //TODO: use MediaType.APPLICATION_XML etc instead of these constants
    public static final String CONTENT_PLAIN = "text/plain";
    public static final String CONTENT_XML = "application/xml";
    public static final String CONTENT_JSON = "application/json";
    public static final String CONTENT_JSONP = "application/jsonp";
    public static final String CONTENT_JPEG = "image/jpeg";

    public static final String EXTENSION_XML = ".xml";
    public static final String EXTENSION_JSON = ".json";
    public static final String EXTENSION_JSONP = ".jsonp";

    public static final String PARAM_EXPAND = "expand";
    public static final String PARAM_VALUE_EXPANDALL = "*";
    public static final String PARAM_VALUE_SEPARATOR = ",";

    public static final String PARAM_MAX = "max-results";
    public static final String PARAM_OFFSET = "start-index";

    public static final String PARAM_CATEGORY = "category";

    public static final String PATH_FIND = "/find";
    public static final String PATH_COUNT = "/count";
    
    /**
     * Create an object. HTTP verb POST.
     *
     * @param obj - the object to create
     * @return object - the newly created object's id
     */
    public String create(T obj);

    /**
     * Retrieve an object. HTTP verb GET.
     *
     * @param id - the string version of the object's id
     * @return object - the object, if it exists
     */
    public T retrieve(String id);

    /**
     * Retrieve an object. HTTP verb GET.
     *
     * @param id - the string version of the object's id
     * @param expand - the fields to be expanded (refer @Expand annotation on DTOs)
     * @return object - the object, if it exists
     */
    public T retrieve(String id, List<String> expand);

    /**
     * Update an object. HTTP verb PUT.
     *
     * @param id - the string version of the object's id
     * @param obj - the object to update
     * @return object - the updated object's id
     */
    public String update(String id, T obj);

    /**
     * Delete an object. HTTP verb DELETE.
     *
     * @param id - the string version of the object's id
     */
    public void delete(String id);

    /**
     * Retrieve all objects. HTTP verb GET.
     *
     * This call can take a max and an offset, useful when a lot of data is returned
     *
     * @param max - the maximum number of results to return per query, may be null
     * @param offset - the number to start the results at, may be null
     * @param expand - the fields to be expanded (refer @Expand annotation on DTOs)
     * @return list - the list of objects, an empty list if none exist
     */
    public List<T> list(Integer max, Integer offset, List<String> expand);

    /**
     * Find a list of objects based on criteria. HTTP verb POST.
     *
     * @param criteria - the search criteria
     * @param expand - the fields to be expanded (refer @Expand annotation on DTOs)
     * @return list - the list of objects, an empty list if none match the criteria
     */
    public List<T> find(SearchCriteria criteria, List<String> expand);

    /**
     * Count the number of objects that fulfil the criteria. HTTP verb POST.
     *
     * @param criteria - the search criteria
     * @return count - the number of objects, zero if none match the criteria
     */
    public Long count(SearchCriteria criteria);

}
