package com.atlassian.plugins.domain.search;

import javax.xml.bind.annotation.XmlType;

@XmlType
public enum SearchOperation {

    EQUALS ("="),
	GREATERTHAN (">"),
	GREATERTHAN_OREQUALS (">="),
	LESSTHAN ("<"),
	LESSTHAN_OREQUALS ("<="),
	LIKE ("LIKE"),

	NOT_EQUALS ("!="),
	NOT_LIKE ("NOT LIKE"),

    IN ("IN"),
    NOT_IN ("NOT IN"),

	IS_NULL ("IS NULL", false),
	IS_NOT_NULL ("IS NOT NULL", false);

    private final String operation;

    private final boolean substituted;

    SearchOperation(String value) {
        this(value, true);
    }

    SearchOperation(String value, boolean substituted) {
        this.operation = value;
        this.substituted = substituted;
    }

    public String getOperation() {
        return operation;
    }

    public boolean isSubstituted() {
        return substituted;
    }
}
