package com.atlassian.plugins.domain.model.user;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Avatar extends AbstractDTO {

    public static final String EXPAND_USER = "user";

    /**
     * The User who uploaded the avatar
     */
    @Expand(EXPAND_USER)
    private User user;

    /**
     * The location of the actual file
     */
    private String location;

    /**
     * The image width in pixels
     */
    private Integer width;

    /**
     * The image height in pixels
     */
    private Integer height;

    /**
     * The file type
     */
    private String imageType;

    public boolean beforeMarshal(Marshaller m) {
        if (!isExpanded()) {
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getImageType() {
        return imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }
}
