package com.atlassian.plugins.domain.model.review;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;
import com.atlassian.plugins.domain.model.plugin.Plugin;
import com.atlassian.plugins.domain.model.plugin.PluginVersion;
import com.atlassian.plugins.domain.model.user.User;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Date;

/**
 * A rating or review of a plugin.
 *
 * Plugins can be rated or reviewed. In practical terms, a rating is a review
 * with no text (ie a blank review field).
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Review extends AbstractDTO {

    public static final String EXPAND_AUTHOR = "author";
    public static final String EXPAND_PLUGIN = "plugin";
    public static final String EXPAND_PLUGINVERSION = "pluginVersion";

    /**
     * The status of the plugin. For example, plugins can be deleted by the author, or be in draft mode.
     */
    private ReviewStatus status = ReviewStatus.DRAFT;

    /**
     * The rating of the category
     */
    private double rating;

    /**
     * The subject of the review - can be null if the user didn't provide any text.
     */
    private String subject;

    /**
     * The text of the review - can be null if the user didn't provide any text.
     */
    private String review;

    /**
     * The date published
     */
    private Date date;

    /**
     * The user that rated / reviewed the product. Users can only rate once.
     */
    @Expand(EXPAND_AUTHOR)
    private User author;

    /**
     * The plugin that the user reviewed.
     */
    @Expand(EXPAND_PLUGIN)
    private Plugin plugin;

    /**
     * The plugin version that the user reviewed.
     */
    @Expand(EXPAND_PLUGINVERSION)
    private PluginVersion pluginVersion;

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
            put("status", status);
            status = null;
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
        if (!isExpanded()) {
            status = (ReviewStatus) get("status");
        }
    }

    public ReviewStatus getStatus() {
        return status;
    }

    public void setStatus(ReviewStatus status) {
        this.status = status;
    }

    public double getRating() {
        return rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getReview() {
        return review;
    }

    public void setReview(String review) {
        this.review = review;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public User getAuthor() {
        return author;
    }

    public void setAuthor(User author) {
        this.author = author;
    }

    public Plugin getPlugin() {
        return plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public PluginVersion getPluginVersion() {
        return pluginVersion;
    }

    public void setPluginVersion(PluginVersion pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

}
