package com.atlassian.plugins.domain.model.plugin;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;
import com.atlassian.plugins.domain.model.category.Category;
import com.atlassian.plugins.domain.model.product.ProductCompatibility;
import com.atlassian.plugins.domain.model.review.ReviewSummary;
import com.atlassian.plugins.domain.wrapper.ListWrapper;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Date;

/**
 * Business Object corresponding to the PluginVersion DTO in shared
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class PluginVersion extends AbstractDTO {

    public static final String EXPAND_PLUGIN = "plugin";
    public static final String EXPAND_STATE = "state";
    public static final String EXPAND_RELEASEFOCUS = "releaseFocus";
    public static final String EXPAND_LICENSE = "license";
    public static final String EXPAND_CATEGORIES = "categories";
    public static final String EXPAND_CATEGORY = "category";
    public static final String EXPAND_CONTRIBUTOR = "contributor";
    public static final String EXPAND_CONTRIBUTORS = "contributors";
    public static final String EXPAND_REQUIREMENT = "requirement";
    public static final String EXPAND_REQUIREMENTS = "requirements";
    public static final String EXPAND_PRODUCTCOMPATIBILITY = "productCompatibility";
    public static final String EXPAND_PRODUCTCOMPATIBILITIES = "productCompatibilities";
    public static final String EXPAND_SCREENSHOT = "screenshot";
    public static final String EXPAND_SCREENSHOTS = "screenshots";
    public static final String EXPAND_REVIEW_SUMMARY = "reviewSummary";

    /**
     * The plugin this version applies to
     */
    @Expand(EXPAND_PLUGIN)
    private Plugin plugin;

    /**
     * Plugin Version Status
     */
    private PluginVersionStatus status = PluginVersionStatus.DRAFT;

    /**
     * lugin version support type - Unsupported, Atlassian, Vendor or Other
     */
    private SupportType supportType = SupportType.UNSUPPORTED;

    /**
     * The textual version number - same as in atlassian-plugin.xml - such as "1.0" or "2.1.4".
     *
     * This version number is used to find and match the plugin that is installed
     * so it's crucial that the version numbers in atlassian-plugin.xml match this.
     */
    private String version;

    /**
     * This is the numeric build number.
     *
     * It does not have to be sequential, but they do have to be unique and a bigger number means a newer release.
     */
    private Long buildNumber;

    /**
     * The version of the plugin system this plugin version is intended for.
     */
    private PluginSystemVersion pluginSystemVersion = PluginSystemVersion.ONE;

    /**
     * A short description of the plugin in plain text (used for search results)
     */
    private String summary;

    /**
     * Plugin description as XHTML
     */
    private String description;

    /**
     * The JIRA Studio instance for this plugin
     */
    private String jiraStudioUrl;

    /**
     * The URL to the JIRA instance
     */
    private String jiraUrl;

    /**
     * The URL to the Confluence instance
     */
    private String confluenceUrl;

    /**
     * The URL to the FishEye instance
     */
    private String fisheyeUrl;

    /**
     * The URL to the Bamboo instance
     */
    private String bambooUrl;

    /**
     * The URL to the Crucible instance
     */
    private String crucibleUrl;

    /**
     * The URL to the forums for the plugin
     */
    private String forumsUrl;

    /**
     * The URL to the JavaDocs for the plugin
     */
    private String javaDocsUrl;

    /**
     * The URL to the documentation for the plugin
     */
    private String documentationUrl;

    /**
     * The URL to generate an evaluation license
     */
    private String generateEvaluationLicenseUrl;

    /**
     * Plugin version release date
     */
    private Date releaseDate;

    /**
     * A brief summary of this release
     */
    private String releaseSummary;

    /**
     * XHTML release notes for this version
     */
    private String releaseNotes;

    /**
     * The URL to the release notes
     */

    private String releaseNotesUrl;

    /**
     *  This is optional but highly recommended. Example states include: alpha, beta, rc, stable
     */
    @Expand(EXPAND_STATE)
    private Category state;

    /**
     * This is optional but highly recommended. Example focuses include: bug fix release, documentation, security fix
     */
    @Expand(EXPAND_RELEASEFOCUS)
    private Category releaseFocus;

    /**
     * The license applied to this plugin version. A PV can only have one license (typically commercial, BSD, ASL, LGPL)
     */
    @Expand(EXPAND_LICENSE)
    private Category license;

    /**
     * A summary of review information
     */
    @Expand(EXPAND_REVIEW_SUMMARY)
    private ReviewSummary reviewSummary;
    
    /**
     * URL with license text
     */
    private String licenseUrl;

    /**
     * The direct URL to download this version of the plugin.
     *
     * This can be over http or https and can handle HTTP Authentication. HTTP Authentication is usually
     * used by commerical plugins, who will issue their users a username/password after purchase.
     */
    private String binaryUrl;

    /**
     * The url to the source - usually a zip or the path to the trunk / tag in subversion
     */
    private String sourceUrl;

    /**
     * URL where donations can be taken
     */
    private String donateUrl;

    /**
     * URL where the product can be bought (or where information on purchasing is found
     */
    private String purchaseUrl;

    /**
     * Learn more link
     */
    private String learnMoreUrl;

    /**
     * The product compatibilities this plugin version works in.
     */
    @Expand(EXPAND_PRODUCTCOMPATIBILITIES)
    @XmlElement
    private ListWrapper<ProductCompatibility> productCompatibilities = new ListWrapper<ProductCompatibility>();

    /**
     * Screenshots of the plugin version.
     *
     * A large screenshot is larger than 500px wide.
     * A medium screenshot is larger than 200px but less than or equal to 500px wide.
     * A small screenshot is smaller than or equal to 200px wide.
     */
    @Expand(EXPAND_SCREENSHOTS)
    @XmlElement
    private ListWrapper<Screenshot> screenshots = new ListWrapper<Screenshot>();


    /**
     * List of categories the plugin is in. The lowest-required level of category should be specified,
     * as the parent categories are automatically included.
     *
     * This is a many-to-many relationship, but we don't care about the relationship from the Category side -
     * we never look at categories and wish they knew their plugins - but we do care about it from the Plugin side -
     * we always want to know its categories.
     */
    @Expand(EXPAND_CATEGORIES)
    @XmlElement
    private ListWrapper<Category> categories = new ListWrapper<Category>();

    /**
     * List of plugin contributors
     */
    @Expand(EXPAND_CONTRIBUTORS)
    @XmlElement
    private ListWrapper<Contributor> contributors = new ListWrapper<Contributor>();

    /**
     * List of requirements
     */
    @Expand(EXPAND_REQUIREMENTS)
    @XmlElement
    private ListWrapper<Requirement> requirements = new ListWrapper<Requirement>();

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
            put("status", status);
            put("productCompatibilities", productCompatibilities);
            put("screenshots", screenshots);
            put("categories", categories);
            put("contributors", contributors);
            put("requirements", requirements);
            put("supportType", supportType);
            status = null;
            productCompatibilities = null;
            screenshots = null;
            categories = null;
            contributors = null;
            requirements = null;
            supportType = null;
        }
        return true;
    }

    @SuppressWarnings("unchecked")
    public void afterMarshal(Marshaller marshaller) {
        if (!isExpanded()) {
            status = (PluginVersionStatus)get("status");
            productCompatibilities = (ListWrapper)get("productCompatibilities");
            screenshots = (ListWrapper)get("screenshots");
            categories = (ListWrapper)get("categories");
            contributors = (ListWrapper)get("contributors");
            requirements = (ListWrapper)get("requirements");
            supportType = (SupportType)get("supportType");
        }
    }

    public Plugin getPlugin() {
        return plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public PluginVersionStatus getStatus() {
        return status;
    }

    public void setStatus(PluginVersionStatus status) {
        this.status = status;
    }

    public SupportType getSupportType() {
        return supportType;
    }

    public void setSupportType(SupportType supportType) {
        this.supportType = supportType;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Long getBuildNumber() {
        return buildNumber;
    }

    public void setBuildNumber(Long buildNumber) {
        this.buildNumber = buildNumber;
    }

    public PluginSystemVersion getPluginSystemVersion() {
        return pluginSystemVersion;
    }

    public void setPluginSystemVersion(PluginSystemVersion pluginSystemVersion) {
        this.pluginSystemVersion = pluginSystemVersion;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getJiraStudioUrl() {
        return jiraStudioUrl;
    }

    public void setJiraStudioUrl(String jiraStudioUrl) {
        this.jiraStudioUrl = jiraStudioUrl;
    }

    public String getJiraUrl() {
        return jiraUrl;
    }

    public void setJiraUrl(String jiraUrl) {
        this.jiraUrl = jiraUrl;
    }

    public String getConfluenceUrl() {
        return confluenceUrl;
    }

    public void setConfluenceUrl(String confluenceUrl) {
        this.confluenceUrl = confluenceUrl;
    }

    public String getFisheyeUrl() {
        return fisheyeUrl;
    }

    public void setFisheyeUrl(String fisheyeUrl) {
        this.fisheyeUrl = fisheyeUrl;
    }

    public String getBambooUrl() {
        return bambooUrl;
    }

    public void setBambooUrl(String bambooUrl) {
        this.bambooUrl = bambooUrl;
    }

    public String getCrucibleUrl() {
        return crucibleUrl;
    }

    public void setCrucibleUrl(String crucibleUrl) {
        this.crucibleUrl = crucibleUrl;
    }

    public String getForumsUrl() {
        return forumsUrl;
    }

    public void setForumsUrl(String forumsUrl) {
        this.forumsUrl = forumsUrl;
    }

    public String getJavaDocsUrl() {
        return javaDocsUrl;
    }

    public void setJavaDocsUrl(String javaDocsUrl) {
        this.javaDocsUrl = javaDocsUrl;
    }

    public String getDocumentationUrl() {
        return documentationUrl;
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public String getGenerateEvaluationLicenseUrl() {
        return generateEvaluationLicenseUrl;
    }

    public void setGenerateEvaluationLicenseUrl(String generateEvaluationLicenseUrl) {
        this.generateEvaluationLicenseUrl = generateEvaluationLicenseUrl;
    }

    public ListWrapper<Category> getCategories() {
        return categories;
    }

    public void setCategories(ListWrapper<Category> categories) {
        this.categories = categories;
    }

    public ListWrapper<Contributor> getContributors() {
        return contributors;
    }

    public void setContributors(ListWrapper<Contributor> contributors) {
        this.contributors = contributors;
    }

    public Date getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getReleaseSummary() {
        return releaseSummary;
    }

    public void setReleaseSummary(String releaseSummary) {
        this.releaseSummary = releaseSummary;
    }

    public String getReleaseNotes() {
        return releaseNotes;
    }

    public void setReleaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public String getReleaseNotesUrl() {
        return releaseNotesUrl;
    }

    public void setReleaseNotesUrl(String releaseNotesUrl) {
        this.releaseNotesUrl = releaseNotesUrl;
    }

    public Category getState() {
        return state;
    }

    public void setState(Category state) {
        this.state = state;
    }

    public Category getReleaseFocus() {
        return releaseFocus;
    }

    public void setReleaseFocus(Category releaseFocus) {
        this.releaseFocus = releaseFocus;
    }

    public Category getLicense() {
        return license;
    }

    public void setLicense(Category license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getBinaryUrl() {
        return binaryUrl;
    }

    public void setBinaryUrl(String binaryUrl) {
        this.binaryUrl = binaryUrl;
    }

    public String getSourceUrl() {
        return sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String getDonateUrl() {
        return donateUrl;
    }

    public void setDonateUrl(String donateUrl) {
        this.donateUrl = donateUrl;
    }

    public String getPurchaseUrl() {
        return purchaseUrl;
    }

    public void setPurchaseUrl(String purchaseUrl) {
        this.purchaseUrl = purchaseUrl;
    }

    public String getLearnMoreUrl() {
        return learnMoreUrl;
    }

    public void setLearnMoreUrl(String learnMoreUrl) {
        this.learnMoreUrl = learnMoreUrl;
    }

    public ListWrapper<ProductCompatibility> getProductCompatibilities() {
        return productCompatibilities;
    }

    public void setProductCompatibilities(ListWrapper<ProductCompatibility> productCompatibilities) {
        this.productCompatibilities = productCompatibilities;
    }

    public ListWrapper<Screenshot> getScreenshots() {
        return screenshots;
    }

    public void setScreenshots(ListWrapper<Screenshot> screenshots) {
        this.screenshots = screenshots;
    }

    public ReviewSummary getReviewSummary() {
        return reviewSummary;
    }

    public void setReviewSummary(ReviewSummary reviewSummary) {
        this.reviewSummary = reviewSummary;
    }

    public ListWrapper<Requirement> getRequirements() {
        return requirements;
    }

    public void setRequirements(ListWrapper<Requirement> requirements) {
        this.requirements = requirements;
    }
}
