package com.atlassian.plugins.domain.model.plugin;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;
import com.atlassian.plugins.domain.model.review.ReviewSummary;
import com.atlassian.plugins.domain.model.vendor.Vendor;
import com.atlassian.plugins.domain.wrapper.ListWrapper;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Class that represents a plugin - data here applies to all versions of a particular plugin.
 *
 * For version-specific data, please use PluginVersion
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Plugin extends AbstractDTO {

    public static final String EXPAND_VERSIONS = "versions";
    public static final String EXPAND_VERSION = "version";
    public static final String EXPAND_LATEST_VERSION = "latestVersion";
    public static final String EXPAND_ICON = "icon";
    public static final String EXPAND_VENDOR = "vendor";
    public static final String EXPAND_REVIEW_SUMMARY = "reviewSummary";

    /**
     * Descriptive name - same as in atlassian-plugin.xml
     */
    private String name;

    /**
     * Plugin key - same as in atlassian-plugin.xml
     */
    private String pluginKey;

    /**
     * Project key - JIRA key
     */
    private String projectKey;

    /**
     * Status of the plugin - only approved plugins are available for download
     */
    private PluginStatus status = PluginStatus.DRAFT;

    /**
     * The homepage of the plugin
     */
    private String homepageUrl;

    /**
     * Defaults to true.
     *
     * Set this to false if the plugin is not meant to be (or not capable of being)
     * automatically installed in the product. (e.g. the UWC)
     */
    private Boolean deployable = true;

    /**
     * The plugin icon
     */
    @Expand(EXPAND_ICON)
    private Icon icon;

    /**
     * The vendor of this plugin
     */
    @Expand(EXPAND_VENDOR)
    private Vendor vendor;

    /**
     * Latest PUBLISHED plugin version
     */
    @Expand(EXPAND_LATEST_VERSION)
    private PluginVersion latestVersion;

    /**
     * A summary of review information
     */
    @Expand(EXPAND_REVIEW_SUMMARY)
    private ReviewSummary reviewSummary;

    /**
     * List of plugin versions
     */
    @Expand(EXPAND_VERSIONS)
    @XmlElement
    private ListWrapper<PluginVersion> versions = new ListWrapper<PluginVersion>();

    /**
     * List of the historical keys
     */
    @XmlElementWrapper(name="historicalKeys")
    @XmlElement(name="historicalKey")
    private List<HistoricalKey> historicalKeys = new ArrayList<HistoricalKey>();

    public boolean beforeMarshal(Marshaller m) {
        if (!isExpanded()) {
            put("status", status);
            put("deployable", deployable);
            put("historicalKeys", historicalKeys);
            put("versions", versions);
            status = null;
            deployable = null;
            versions = null;
            historicalKeys = null;
        }
        return true;
    }

    @SuppressWarnings("unchecked")
    public void afterMarshal(Marshaller marshaller) {
        if (!isExpanded()) {
            status = (PluginStatus) get("status");
            deployable = (Boolean) get("deployable");
            historicalKeys = (List) get("historicalKeys");
            versions = (ListWrapper) get("versions");
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPluginKey() {
        return pluginKey;
    }

    public void setPluginKey(String pluginKey) {
        this.pluginKey = pluginKey;
    }

    public PluginStatus getStatus() {
        return status;
    }

    public void setStatus(PluginStatus status) {
        this.status = status;
    }

    public ListWrapper<PluginVersion> getVersions() {
        return versions;
    }

    public void setVersions(ListWrapper<PluginVersion> versions) {
        this.versions = versions;
    }

    public PluginVersion getLatestVersion() {
        return latestVersion;
    }

    public void setLatestVersion(PluginVersion latestVersion) {
        this.latestVersion = latestVersion;
    }

    public boolean isDeployable() {
        return deployable;
    }

    public void setDeployable(boolean deployable) {
        this.deployable = deployable;
    }

    public Icon getIcon() {
        return icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Vendor getVendor() {
        return vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public Boolean getDeployable() {
        return deployable;
    }

    public void setDeployable(Boolean deployable) {
        this.deployable = deployable;
    }

    public ReviewSummary getReviewSummary() {
        return reviewSummary;
    }

    public void setReviewSummary(ReviewSummary reviewSummary) {
        this.reviewSummary = reviewSummary;
    }

    public String getHomepageUrl() {
        return homepageUrl;
    }

    public void setHomepageUrl(String homepageUrl) {
        this.homepageUrl = homepageUrl;
    }

    public List<HistoricalKey> getHistoricalKeys() {
        return historicalKeys;
    }

    public void setHistoricalKeys(List<HistoricalKey> historicalKeys) {
        this.historicalKeys = historicalKeys;
    }

    public String getProjectKey() {
        return projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }
}
