package com.atlassian.plugins.domain.model.plugin;

import com.atlassian.plugins.domain.AbstractDTO;
import com.atlassian.plugins.domain.model.Expand;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;


/**
 * Class that represents a plugin icon - one per plugin
 */

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Icon extends AbstractDTO {

    public static final String EXPAND_PLUGIN = "plugin";

    /**
     * The location of the actual file
     */
    private String location;

    /**
     * The alternative text
     */
    private String altText;

    /**
     * The image width in pixels
     */
    private Integer width;

    /**
     * The image height in pixels
     */
    private Integer height;

    /**
     * The file type
     */
    private String imageType;

    /**
     * The plugin this icon is for
     */
    @Expand(EXPAND_PLUGIN)
    private Plugin plugin;

    public boolean beforeMarshal(Marshaller m) {
        if (!isExpanded()) {
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getAltText() {
        return altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Plugin getPlugin() {
        return plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public String getImageType() {
        return imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }
}
