package com.atlassian.plugins.domain.model.category;

import com.atlassian.plugins.domain.AbstractDTO;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * A hierarchical category, where the category can represent a product, a type, a license, a state.
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Category extends AbstractDTO {

    /**
     * Category name - does not have to be unique
     */
    private String name;

    /**
     * Category type -- allows for the category to be referred to in code. Parents and children must share the same type.
     */
    private CategoryType type = CategoryType.CATEGORY;

    /**
     * Whether the category is selectable, or only exists for historical purposes
     */
    private Boolean active = true;

    /**
     * Category parent
     */
    private String parentId;

    /**
     * Sort order - lets us sort within a category
     */
    private Integer sortOrder = 1;

    /**
     * A unique key (across all categories) which enables the category to be referred to programatically.
     *
     * Not all categories have a key, so this may be null.
     */
    private String key;

    /**
     * Description - brief description of the category. May be null.
     */
    private String description;

    /**
     * Value - an additional value associated with the category. May be null.
     *
     * For instance, most commonly, it's a URL.  
     */
    private String value;

    /**
     * Returns true when the category is a head category, defined as a category with no parents
     *
     * @return true when the category is the top of its hierarchy
     */
    public boolean isHeadCategory() {
        return (parentId == null);
    }

    public String toString() {
        return this.name;
    }

    public boolean beforeMarshal(javax.xml.bind.Marshaller marshaller) {
        if (!isExpanded()) {
            put("sortOrder", sortOrder);
            put("active", active);
            put("type", type);
            sortOrder = null;
            active = null;
            type = null;
        }
        return true;
    }

    public void afterMarshal(Marshaller marshaller) {
        if (!isExpanded()) {
            sortOrder = (Integer) get("sortOrder");
            active = (Boolean) get("active");
            type = (CategoryType) get("type");
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CategoryType getType() {
        return type;
    }

    public void setType(CategoryType type) {
        this.type = type;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public int getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Boolean getActive() {
        return active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
