/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.service.user;

import com.atlassian.plugins.PacException;
import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.Status;
import com.atlassian.plugins.domain.model.user.Avatar;
import com.atlassian.plugins.service.user.AvatarService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvatarServiceClientImpl
extends AbstractRestServiceClient<Avatar>
implements AvatarService {
    @Override
    protected Class<Avatar> getEntity() {
        return Avatar.class;
    }

    @Override
    protected String getPath() {
        return "/avatar";
    }

    public InputStream fetch(String id) {
        throw new UnsupportedOperationException("Fetch should be called directly, not through the client");
    }

    public void upload(InputStream in, Avatar avatar) {
        avatar.setExpanded(true);
        if (avatar.getId() == null) {
            String id = this.create(avatar);
            avatar.setId(id);
        } else {
            this.update(avatar.getId(), avatar);
        }
        String boundary = "boundary_" + avatar.getId() + "_" + System.currentTimeMillis();
        WebResource.Builder webResource = this.buildWebResource(this.getWebResource().path("/" + avatar.getId() + "/upload"));
        webResource = (WebResource.Builder)webResource.type("multipart/mixed;boundary=\"" + boundary + "\"");
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.field("file", (Object)in, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)multiPart);
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return;
        }
        Status status = (Status)this.getEntityFromResponse(response, Status.class);
        throw new PacException("Unexpected Response: " + response.getStatus(), status);
    }
}

