/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.service.plugin;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.plugin.PluginCompatibilityStatus;
import com.atlassian.plugins.domain.model.plugin.PluginVersion;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.plugin.PluginVersionService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginVersionServiceClientImpl
extends AbstractRestServiceClient<PluginVersion>
implements PluginVersionService {
    @Override
    protected Class<PluginVersion> getEntity() {
        return PluginVersion.class;
    }

    @Override
    protected String getPath() {
        return "/pluginversion";
    }

    public List<PluginVersion> findCompatiblePluginVersions(String productId, Long buildNumber, String query, Integer max, Integer offset, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/find/compatible/" + productId + "/" + buildNumber);
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (query != null) {
            map.putSingle("q", query);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add("expand", ex);
            }
        }
        if (!map.isEmpty()) {
            webResource = webResource.queryParams((MultivaluedMap)map);
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.get(ClientResponse.class), ListWrapper.class)).getList() == null) {
            return new ArrayList<PluginVersion>();
        }
        return listWrapper.getList();
    }

    public List<PluginVersion> findUpdates(String productId, Long buildNumber, Map<String, String> pluginsAndVersions, Integer max, Integer offset, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/find/updates/" + productId + "/" + buildNumber);
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add("expand", ex);
            }
        }
        if (!map.isEmpty()) {
            webResource = webResource.queryParams((MultivaluedMap)map);
        }
        Form form = new Form();
        if (pluginsAndVersions != null && !pluginsAndVersions.isEmpty()) {
            for (Map.Entry<String, String> pluginAndVersion : pluginsAndVersions.entrySet()) {
                form.add("pk", pluginAndVersion.getKey());
                form.add("pv", pluginAndVersion.getValue());
            }
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.post(ClientResponse.class, (Object)form), ListWrapper.class)).getList() == null) {
            return new ArrayList<PluginVersion>();
        }
        return listWrapper.getList();
    }

    public List<PluginVersion> findFeaturedPlugins(String productId, Long buildNumber, Integer max, Integer offset, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/find/featured/" + productId + "/" + buildNumber);
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add("expand", ex);
            }
        }
        if (!map.isEmpty()) {
            webResource = webResource.queryParams((MultivaluedMap)map);
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.get(ClientResponse.class), ListWrapper.class)).getList() == null) {
            return new ArrayList<PluginVersion>();
        }
        return listWrapper.getList();
    }

    public List<PluginVersion> findCompatiblePluginVersionsByPluginKey(String productId, Long buildNumber, String pluginKey, Integer max, Integer offset, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/find/compatiblekey/" + productId + "/" + buildNumber + "/" + pluginKey);
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add("expand", ex);
            }
        }
        if (!map.isEmpty()) {
            webResource = webResource.queryParams((MultivaluedMap)map);
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.get(ClientResponse.class), ListWrapper.class)).getList() == null) {
            return new ArrayList<PluginVersion>();
        }
        return listWrapper.getList();
    }

    public List<PluginCompatibilityStatus> getCompatibilityStatus(String productKey, Long currentProductBuildNUmber, Long targetProductBuildNumber, Map<String, String> pluginKeysAndVersions, Integer max, Integer offset, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/find/compatibilitystatus/" + productKey + "/" + currentProductBuildNUmber + "/" + targetProductBuildNumber);
        Form form = new Form();
        if (max != null) {
            form.add("max-results", (Object)max);
        }
        if (offset != null) {
            form.add("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                form.add("expand", ex);
            }
        }
        if (pluginKeysAndVersions != null) {
            for (String key : pluginKeysAndVersions.keySet()) {
                form.add("pk", key);
                form.add("pv", pluginKeysAndVersions.get(key));
            }
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.post(ClientResponse.class, (Object)form), ListWrapper.class)).getList() == null) {
            return new ArrayList<PluginCompatibilityStatus>();
        }
        return listWrapper.getList();
    }

    public List<PluginVersion> findPopularPluginVersions(String productKey, Long buildNumber, Integer max, Integer offset, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/find/popular/" + productKey + "/" + buildNumber);
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add("expand", ex);
            }
        }
        if (!map.isEmpty()) {
            webResource = webResource.queryParams((MultivaluedMap)map);
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.get(ClientResponse.class), ListWrapper.class)).getList() == null) {
            return new ArrayList<PluginVersion>();
        }
        return listWrapper.getList();
    }

    public List<PluginVersion> findSupportedPluginVersions(String productKey, Long buildNumber, Integer max, Integer offset, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/find/supported/" + productKey + "/" + buildNumber);
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add("expand", ex);
            }
        }
        if (!map.isEmpty()) {
            webResource = webResource.queryParams((MultivaluedMap)map);
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)webResource.get(ClientResponse.class), ListWrapper.class)).getList() == null) {
            return new ArrayList<PluginVersion>();
        }
        return listWrapper.getList();
    }
}

