/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.service.plugin;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.plugin.Download;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.plugin.DownloadService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadServiceClientImpl
extends AbstractRestServiceClient<Download>
implements DownloadService {
    @Override
    protected Class<Download> getEntity() {
        return Download.class;
    }

    @Override
    protected String getPath() {
        return "/download";
    }

    public Long totalDownloadsForPlugin(String pluginId) {
        WebResource webResource = this.getWebResource();
        String path = "/total/plugin/" + pluginId;
        webResource = webResource.path(path);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        String total = (String)this.getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public Long totalDownloadsForPluginVersion(String pluginVersionId) {
        WebResource webResource = this.getWebResource();
        String path = "/total/pluginVersion/" + pluginVersionId;
        webResource = webResource.path(path);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        String total = (String)this.getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public String downloadPluginVersion(String pluginVersionId) {
        throw new UnsupportedOperationException("This method not supported through client");
    }

    public List<Download> getDownloads(String pluginId, String product, Date start, Date end, String period) {
        if (pluginId == null || product == null || start == null || end == null || period == null) {
            throw new IllegalArgumentException("Plugin Id, Product, Start Date, End Date, and Period cannot be null");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        WebResource webResource = this.getWebResource();
        ClientResponse response = (ClientResponse)this.buildWebResource(webResource = webResource.path("/aggregate/" + pluginId + "/" + product + "/" + df.format(start) + "/" + df.format(end) + "/" + period)).get(ClientResponse.class);
        ListWrapper listWrapper = (ListWrapper)this.getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) {
            return new ArrayList<Download>();
        }
        return listWrapper.getList();
    }
}

