/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.client.service;

import com.atlassian.plugins.PacException;
import com.atlassian.plugins.domain.DTO;
import com.atlassian.plugins.domain.authorisation.AuthorisationException;
import com.atlassian.plugins.domain.model.Status;
import com.atlassian.plugins.domain.search.SearchCriteria;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.RestService;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.ApacheHttpClientHandler;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRestServiceClient<T extends DTO>
implements RestService<T> {
    public static final String VERSION = "1.0";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private String baseUrl;
    private String username;
    private String password;
    private String alternativeUsername;
    private boolean logWebResourceRequests = false;

    protected abstract Class<T> getEntity();

    protected abstract String getPath();

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setAlternativeUsername(String alternativeUsername) {
        this.alternativeUsername = alternativeUsername;
    }

    public String getAlternativeUsername() {
        return this.alternativeUsername;
    }

    public void setLogWebResourceRequests(boolean logWebResourceRequests) {
        this.logWebResourceRequests = logWebResourceRequests;
    }

    protected WebResource getWebResource() {
        DefaultClientConfig config = new DefaultClientConfig();
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        String host = System.getProperty("http.proxyHost");
        Integer port = Integer.getInteger("http.proxyPort");
        if (host != null && port != null) {
            httpClient.getHostConfiguration().setProxy(host, port.intValue());
        }
        ApacheHttpClientHandler handler = new ApacheHttpClientHandler(httpClient);
        ApacheHttpClient client = new ApacheHttpClient(handler, (ClientConfig)config);
        this.addProxyAuthFilter((Client)client);
        WebResource resource = client.resource(this.baseUrl + "/" + VERSION + this.getPath() + "/");
        if (this.logWebResourceRequests) {
            resource.addFilter((ClientFilter)new LoggingFilter());
        }
        return resource;
    }

    protected WebResource.Builder buildWebResource(WebResource resource) {
        String encoding = null;
        if (this.username != null && this.password != null) {
            String userPassword = this.alternativeUsername == null ? this.username + ":" + this.password : this.username + " " + this.alternativeUsername + ":" + this.password;
            encoding = new BASE64Encoder().encode(userPassword.getBytes());
            encoding = encoding.replaceAll("\r", "").replaceAll("\n", "");
        }
        if (encoding == null) {
            return resource.type("application/xml");
        }
        return (WebResource.Builder)resource.type("application/xml").header("Authorization", (Object)("Basic " + encoding));
    }

    protected Object getEntityFromResponse(ClientResponse response, Class entityClass) {
        try {
            if (response.getStatus() == Response.Status.FORBIDDEN.getStatusCode()) {
                throw new AuthorisationException((Status)response.getEntity(Status.class));
            }
        }
        catch (AuthorisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AuthorisationException(String.valueOf(Response.Status.FORBIDDEN.getStatusCode()), (Throwable)e);
        }
        try {
            if (response.getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                Status status = (Status)response.getEntity(Status.class);
                if (Response.Status.FORBIDDEN.toString().equals(status.getCode())) {
                    throw new AuthorisationException(status);
                }
                throw new PacException(status);
            }
        }
        catch (AuthorisationException e) {
            throw e;
        }
        catch (PacException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PacException(String.valueOf(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()), (Throwable)e);
        }
        if (entityClass == null) {
            return null;
        }
        try {
            return response.getEntity(entityClass);
        }
        catch (Exception e) {
            Status entity;
            try {
                entity = (Status)response.getEntity(Status.class);
            }
            catch (Exception ex) {
                throw new PacException(String.valueOf(response.getStatus()), (Throwable)e);
            }
            throw new PacException(entity, (Throwable)e);
        }
    }

    public String create(T obj) {
        obj.setExpanded(true);
        ClientResponse response = (ClientResponse)this.buildWebResource(this.getWebResource()).post(ClientResponse.class, obj);
        Status status = (Status)this.getEntityFromResponse(response, Status.class);
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return status.getSubCode();
        }
        throw new PacException("Unexpected Response: " + response.getStatus(), status);
    }

    public T retrieve(String id) {
        return this.retrieve(id, null);
    }

    public T retrieve(String id, List<String> expand) {
        ClientResponse cr;
        WebResource webResource = this.getWebResource();
        if (expand != null && !expand.isEmpty()) {
            MultivaluedMapImpl map = new MultivaluedMapImpl();
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ex);
            }
            map.putSingle("expand", sb.toString());
            webResource = webResource.queryParams((MultivaluedMap)map);
        }
        if ((cr = (ClientResponse)this.buildWebResource(webResource = webResource.path(id)).get(ClientResponse.class)).getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            return null;
        }
        return (T)((DTO)this.getEntityFromResponse(cr, this.getEntity()));
    }

    public String update(String id, T obj) {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path(id);
        obj.setExpanded(true);
        ClientResponse response = (ClientResponse)this.buildWebResource(webResource).put(ClientResponse.class, obj);
        Status status = (Status)this.getEntityFromResponse(response, Status.class);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return status.getSubCode();
        }
        throw new PacException("Unexpected Response: " + response.getStatus(), status);
    }

    public void delete(String id) {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path(id);
        ClientResponse response = (ClientResponse)this.buildWebResource(webResource).delete(ClientResponse.class);
        this.getEntityFromResponse(response, null);
    }

    public List<T> list(Integer max, Integer offset, List<String> expand) {
        ClientResponse response;
        ListWrapper listWrapper;
        WebResource webResource = this.getWebResource();
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) {
            map.putSingle("max-results", (Object)max);
        }
        if (offset != null) {
            map.putSingle("start-index", (Object)offset);
        }
        if (expand != null && !expand.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ex);
            }
            map.putSingle("expand", sb.toString());
        }
        if ((listWrapper = (ListWrapper)this.getEntityFromResponse(response = (ClientResponse)this.buildWebResource(webResource = webResource.queryParams((MultivaluedMap)map)).get(ClientResponse.class), ListWrapper.class)).getList() == null) {
            return new ArrayList();
        }
        return listWrapper.getList();
    }

    public List<T> find(SearchCriteria criteria, List<String> expand) {
        WebResource webResource = this.getWebResource();
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (expand != null && !expand.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ex);
            }
            map.putSingle("expand", sb.toString());
        }
        webResource = webResource.queryParams((MultivaluedMap)map);
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.buildWebResource(webResource = webResource.path("/find")).type("application/xml")).post(ClientResponse.class, (Object)criteria);
        ListWrapper listWrapper = (ListWrapper)this.getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) {
            return new ArrayList();
        }
        return listWrapper.getList();
    }

    public Long count(SearchCriteria criteria) {
        WebResource webResource = this.getWebResource();
        webResource = webResource.path("/count");
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.buildWebResource(webResource).type("application/xml")).post(ClientResponse.class, (Object)criteria);
        String count = (String)this.getEntityFromResponse(response, String.class);
        return new Long(count);
    }

    private void addProxyAuthFilter(Client client) {
        String proxyUser = System.getProperty("http.proxyUser");
        String proxyPassword = System.getProperty("http.proxyPassword");
        if (proxyUser != null && proxyPassword != null) {
            client.addFilter((ClientFilter)new BasicProxyAuthFilter(proxyUser, proxyPassword));
        }
    }

    final class BasicProxyAuthFilter
    extends ClientFilter {
        private final String auth;

        BasicProxyAuthFilter(String username, String password) {
            try {
                this.auth = "Basic " + new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes("ASCII")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("That's some funky JVM you've got there", e);
            }
        }

        public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
            MultivaluedMap headers = cr.getMetadata();
            if (!headers.containsKey((Object)AbstractRestServiceClient.PROXY_AUTHORIZATION)) {
                headers.add((Object)AbstractRestServiceClient.PROXY_AUTHORIZATION, (Object)this.auth);
            }
            return this.getNext().handle(cr);
        }
    }
}

