package com.atlassian.plugins.client.service.user;

import com.atlassian.plugins.PacException;
import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.Status;
import com.atlassian.plugins.domain.model.user.Avatar;
import com.atlassian.plugins.service.user.AvatarService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.io.InputStream;

public class AvatarServiceClientImpl extends AbstractRestServiceClient<Avatar> implements AvatarService {

    protected Class<Avatar> getEntity() {
        return Avatar.class;
    }

    protected String getPath() {
        return PATH;
    }

    public InputStream fetch(String id) {
        throw new UnsupportedOperationException("Fetch should be called directly, not through the client");
    }

    public void upload(InputStream in, Avatar avatar) {

        // Objects being sent back to the server needs to be expanded so that all the fields are encoded in the XML
        avatar.setExpanded(true);

        //first, create or update the icon
        if (avatar.getId() == null) {
            String id = create(avatar);
            avatar.setId(id);
        } else {
            update(avatar.getId(), avatar);
        }

        //next, create or update the attachment
        String boundary = "boundary_" + avatar.getId() + "_" + System.currentTimeMillis();

        WebResource.Builder webResource = buildWebResource(getWebResource().path("/" + avatar.getId() + PATH_UPLOAD));
        webResource = webResource.type("multipart/mixed;boundary=\"" + boundary + "\"");

        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.field("file", in, MediaType.APPLICATION_OCTET_STREAM_TYPE);

        ClientResponse response = webResource.post(ClientResponse.class, multiPart);
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) return;

        //this will handle 500s and 401s
        Status status = (Status) getEntityFromResponse(response, Status.class);

        throw new PacException("Unexpected Response: " + response.getStatus(), status);
    }    
}
