package com.atlassian.plugins.client.service.review;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.review.Review;
import com.atlassian.plugins.domain.model.review.ReviewStatus;
import com.atlassian.plugins.service.review.ReviewService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;

public class ReviewServiceClientImpl extends AbstractRestServiceClient<Review> implements ReviewService {

    protected Class<Review> getEntity() {
        return Review.class;
    }

    protected String getPath() {
        return PATH ;
    }

    public Long totalReviewsForPlugin(String pluginId, ReviewStatus reviewStatus) {

        WebResource webResource = getWebResource();

        String path = "plugin/" + pluginId + "/count";
        
        if (reviewStatus != null) path = "plugin/" + pluginId + "/" + reviewStatus + "/count";

        webResource = webResource.path(path);

        ClientResponse response = webResource.type(CONTENT_XML).get(ClientResponse.class);
        String total = (String)getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public Double averageRatingForPlugin(String pluginId, ReviewStatus reviewStatus) {

        WebResource webResource = getWebResource();

        String path = "plugin/" + pluginId + "/average";

        if (reviewStatus != null) path = "plugin/" + pluginId + "/" + reviewStatus + "/average";

        webResource = webResource.path(path);

        ClientResponse response = webResource.get(ClientResponse.class);

        if (response.getStatus() == 204) return null;

        String average = (String)getEntityFromResponse(response, String.class);

        return new Double(average);
    }

    public Long totalReviewsForPluginVersion(String pluginVersionId, ReviewStatus reviewStatus) {

        WebResource webResource = getWebResource();

        String path = "pluginVersion/" + pluginVersionId + "/count";

        if (reviewStatus != null) path = "pluginVersion/" + pluginVersionId + "/" + reviewStatus + "/count";

        webResource = webResource.path(path);

        ClientResponse response = webResource.type(CONTENT_XML).get(ClientResponse.class);
        String total = (String)getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public Double averageRatingForPluginVersion(String pluginVersionId, ReviewStatus reviewStatus) {

        WebResource webResource = getWebResource();

        String path = "pluginVersion/" + pluginVersionId + "/average";

        if (reviewStatus != null) path = "pluginVersion/" + pluginVersionId + "/" + reviewStatus + "/average";

        webResource = webResource.path(path);

        ClientResponse response = webResource.get(ClientResponse.class);

        if (response.getStatus() == 204) return null;

        String average = (String)getEntityFromResponse(response, String.class);

        return new Double(average);
    }
}
