package com.atlassian.plugins.client.service.product;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.service.product.ProductService;
import com.atlassian.plugins.domain.model.product.Product;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.domain.search.SearchCriteria;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.ClientResponse;

import java.util.List;
import java.util.ArrayList;

public class ProductServiceClientImpl extends AbstractRestServiceClient<Product> implements ProductService
{
    protected Class<Product> getEntity()
    {
        return Product.class;
    }

    protected String getPath()
    {
        return PATH;
    }

    @Override
    public String create(Product obj) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Product retrieve(String id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Product retrieve(String id, List<String> expand) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String update(String id, Product obj) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void delete(String id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public List<Product> list(Integer max, Integer offset, List<String> expand) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public List<Product> find(SearchCriteria criteria, List<String> expand) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Long count(SearchCriteria criteria) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Product getLatestProductVersion(String productKey)
    {
        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_LATEST + "/" + productKey);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        return (Product) getEntityFromResponse(response, Product.class);
    }

    public List<Product> getProductVersionsAfterVersion(String productKey, Long buildNumber)
    {
        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_AFTER + "/" + productKey + "/" + buildNumber);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper<Product> listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Product>();
        return listWrapper.getList();
    }
}
