package com.atlassian.plugins.client.service.product;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.product.CompatibilityMatrix;
import com.atlassian.plugins.domain.model.product.ProductCompatibility;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.product.ProductCompatibilityService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import org.apache.commons.lang.StringUtils;

import javax.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProductCompatibilityServiceClientImpl extends AbstractRestServiceClient<ProductCompatibility> implements ProductCompatibilityService {

    protected Class<ProductCompatibility> getEntity() {
        return ProductCompatibility.class;
    }

    protected String getPath() {
        return PATH;
    }

    @SuppressWarnings("unchecked")
    public List<CompatibilityMatrix> findCompatibilityMatrix(String pluginId, String reductionType, List<String> expand) {

        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_MATRIX + "/" + pluginId);

        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (reductionType != null) map.putSingle(PARAM_REDUCE, reductionType);

        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add(PARAM_EXPAND, ex);
            }
        }

        if (!map.isEmpty()) webResource = webResource.queryParams(map);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper<CompatibilityMatrix> listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<CompatibilityMatrix>();
        return listWrapper.getList();
    }

    public List<ProductCompatibility> getUpgradeablePluginVersions(String categoryId, List<String> expand) {

        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_AUTOUPDATE);

        MultivaluedMapImpl map = new MultivaluedMapImpl();

        if (StringUtils.isNotBlank(categoryId)) {
            map.putSingle(PARAM_CATEGORYID, categoryId);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add(PARAM_EXPAND, ex);
            }
        }

        if (!map.isEmpty()) {
            webResource = webResource.queryParams(map);
        }
        ClientResponse response = webResource.get(ClientResponse.class);

        @SuppressWarnings("unchecked") // this cast never fails because nothing else is put in the response
        ListWrapper<ProductCompatibility> listWrapper =
                (ListWrapper) getEntityFromResponse(response, ListWrapper.class);

        return listWrapper.getList() != null ? listWrapper.getList() : Collections.<ProductCompatibility>emptyList();
    }

    public List<ProductCompatibility> upgradePluginVersions(String toCategoryId, List<String> expand) {

        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_AUTOUPDATE);

        MultivaluedMapImpl map = new MultivaluedMapImpl();

        if (StringUtils.isNotBlank(toCategoryId)) {
            map.putSingle(PARAM_CATEGORYID, toCategoryId);
        }
        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add(PARAM_EXPAND, ex);
            }
        }

        ClientResponse response = webResource.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)
                .post(ClientResponse.class, map);

        @SuppressWarnings("unchecked") // this cast never fails because nothing else is put in the response
        ListWrapper<ProductCompatibility> listWrapper =
                (ListWrapper) getEntityFromResponse(response, ListWrapper.class);

        return listWrapper.getList() != null ? listWrapper.getList() : Collections.<ProductCompatibility>emptyList();
    }
}
