package com.atlassian.plugins.client.service.plugin;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.plugin.PluginCompatibilityStatus;
import com.atlassian.plugins.domain.model.plugin.PluginVersion;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.plugin.PluginVersionService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.util.MultivaluedMapImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SuppressWarnings("unchecked")
public class PluginVersionServiceClientImpl extends AbstractRestServiceClient<PluginVersion> implements PluginVersionService {

    @Override
    protected Class<PluginVersion> getEntity() {
        return PluginVersion.class;
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    public List<PluginVersion> findCompatiblePluginVersions(String productId, Long buildNumber, String query,
        Integer max, Integer offset, List<String> expand) {
        
        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDCOMPATIBLE + "/" + productId + "/" + buildNumber);

        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);
        if (query != null) map.putSingle(PARAM_QUERY, query);

        if (expand != null && !expand.isEmpty())
        {
            for (String ex : expand) {
                map.add(PARAM_EXPAND, ex);
            }
        }

        if (!map.isEmpty()) webResource = webResource.queryParams(map);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper<PluginVersion> listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<PluginVersion>();
        return listWrapper.getList();
    }

    public List<PluginVersion> findUpdates(String productId, Long buildNumber, Map<String, String> pluginsAndVersions, Integer max, Integer offset, List<String> expand) {

        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDUPDATES + "/" + productId + "/" + buildNumber);

        MultivaluedMapImpl map = new MultivaluedMapImpl();

        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);

        if (expand != null && !expand.isEmpty())
        {
            for (String ex : expand) {
                map.add(PARAM_EXPAND, ex);
            }
        }

        if (!map.isEmpty()) webResource = webResource.queryParams(map);

        Form form = new Form();
        if (pluginsAndVersions != null && !pluginsAndVersions.isEmpty())
        {
            for (Map.Entry<String, String> pluginAndVersion : pluginsAndVersions.entrySet()) {
                form.add(PARAM_PLUGINKEYS, pluginAndVersion.getKey());
                form.add(PARAM_PLUGINVERSIONS, pluginAndVersion.getValue());
            }
        }

        ClientResponse response = webResource.post(ClientResponse.class, form);

        //this call will handle 401s and 500s
        ListWrapper<PluginVersion> listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<PluginVersion>();
        return listWrapper.getList();
    }

    public List<PluginVersion> findFeaturedPlugins(String productId, Long buildNumber, Integer max, Integer offset, List<String> expand) {

        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDFEATURED + "/" + productId + "/" + buildNumber);

        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);

        if (expand != null && !expand.isEmpty())
        {
            for (String ex : expand) {
                map.add(PARAM_EXPAND, ex);
            }
        }

        if (!map.isEmpty()) webResource = webResource.queryParams(map);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper<PluginVersion> listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<PluginVersion>();
        return listWrapper.getList();

    }

    public List<PluginVersion> findCompatiblePluginVersionsByPluginKey(String productId, Long buildNumber, String pluginKey,
        Integer max, Integer offset, List<String> expand) {

        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDCOMPATIBLEKEY + "/" + productId + "/" + buildNumber + "/" + pluginKey);

        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);

        if (expand != null && !expand.isEmpty()) {
            for (String ex : expand) {
                map.add(PARAM_EXPAND, ex);
            }
        }

        if (!map.isEmpty()) webResource = webResource.queryParams(map);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper<PluginVersion> listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<PluginVersion>();
        return listWrapper.getList();

    }

    public List<PluginCompatibilityStatus> getCompatibilityStatus(String productKey, Long currentProductBuildNUmber,
        Long targetProductBuildNumber, Map<String, String> pluginKeysAndVersions, Integer max, Integer offset, List<String> expand) {

        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDCOMPATIBILITYSTATUS + "/" + productKey + "/" + currentProductBuildNUmber + "/" + targetProductBuildNumber);

        Form form = new Form();
        if (max != null) form.add(PARAM_MAX, max);
        if (offset != null) form.add(PARAM_OFFSET, offset);

        if (expand != null && !expand.isEmpty())
        {
            for (String ex : expand) {
                form.add(PARAM_EXPAND, ex);
            }
        }

        if (pluginKeysAndVersions != null)
        {
            for (String key : pluginKeysAndVersions.keySet()) {
                form.add(PARAM_PLUGINKEYS, key);
                form.add(PARAM_PLUGINVERSIONS, pluginKeysAndVersions.get(key));
            }
        }

        ClientResponse response = webResource.post(ClientResponse.class, form);

        //this call will handle 401s and 500s
        ListWrapper<PluginCompatibilityStatus> listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<PluginCompatibilityStatus>();
        return listWrapper.getList();

    }

    public List<PluginVersion> findPopularPluginVersions(String productKey, Long buildNumber, Integer max, Integer offset, List<String> expand) {
        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDPOPULARPLUGINS + "/" + productKey + "/" + buildNumber);

        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);

        if (expand != null && !expand.isEmpty())
        {
            for (String ex : expand) {
                map.add(PARAM_EXPAND, ex);
            }
        }

        if (!map.isEmpty()) webResource = webResource.queryParams(map);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper<PluginVersion> listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<PluginVersion>();
        return listWrapper.getList();
    }

    public List<PluginVersion> findSupportedPluginVersions(String productKey, Long buildNumber, Integer max, Integer offset, List<String> expand) {
        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDSUPPORTEDPLUGINS + "/" + productKey + "/" + buildNumber);

        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);

        if (expand != null && !expand.isEmpty())
        {
            for (String ex : expand) {
                map.add(PARAM_EXPAND, ex);
            }
        }

        if (!map.isEmpty()) webResource = webResource.queryParams(map);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper<PluginVersion> listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<PluginVersion>();
        return listWrapper.getList();
    }
}
