package com.atlassian.plugins.client.service.plugin;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.plugin.Plugin;
import com.atlassian.plugins.domain.model.plugin.Download;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.plugin.PluginService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.util.MultivaluedMapImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;

@SuppressWarnings("unchecked")
public class PluginServiceClientImpl extends AbstractRestServiceClient<Plugin> implements PluginService {

    protected Class<Plugin> getEntity() {
        return Plugin.class;
    }

    protected String getPath() {
        return PATH;
    }

    public List<Plugin> popularPlugins(Integer max, Integer offset, List<String> expand) {
        return popularPlugins(max, offset, expand, null);
    }


    public List<Plugin> popularPlugins(Integer max, Integer offset, List<String> expand, String categoryId) {

        //assemble the query
        WebResource webResource = getWebResource();
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);
        if (expand != null && !expand.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) sb.append(PARAM_VALUE_SEPARATOR);
                sb.append(ex);
            }
            map.putSingle(PARAM_EXPAND, sb.toString());
        }
        if (categoryId != null) map.putSingle(PARAM_CATEGORY, categoryId);        
        webResource = webResource.queryParams(map);        
        webResource = webResource.path(PATH_POPULARPLUGINS);

        //make the call and convert to a proper list
        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Plugin>();
        return listWrapper.getList();
    }


    public List<Plugin> recentlyUpdatedPlugins(String categoryId, Integer max, Integer offset, List<String> expand) {

        //assemble the query
        WebResource webResource = getWebResource();
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);
        if (expand != null && !expand.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) sb.append(PARAM_VALUE_SEPARATOR);
                sb.append(ex);
            }
            map.putSingle(PARAM_EXPAND, sb.toString());
        }
        if (categoryId != null) map.putSingle(PARAM_CATEGORY, categoryId);
        webResource = webResource.queryParams(map);
        webResource = webResource.path(PATH_RECENTPLUGINS);

        //make the call and convert to a proper list
        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Plugin>();
        return listWrapper.getList();
    }

    public List<Plugin> pluginsByCategory(String categoryId, Integer max, Integer offset, List<String> expand) {

        //assemble the query
        WebResource webResource = getWebResource();

        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);
        if (expand != null && !expand.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) sb.append(PARAM_VALUE_SEPARATOR);
                sb.append(ex);
            }
            map.putSingle(PARAM_EXPAND, sb.toString());
        }
        webResource = webResource.queryParams(map);
        webResource = webResource.path(PATH_PLUGINSBYCATEGORY + "/" + categoryId);

        //make the call and convert to a proper list
        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Plugin>();
        return listWrapper.getList();
    }

    public List<Plugin> pluginsByPluginKey(List<String> pluginKeys, Integer max, Integer offset, List<String> expand) {

        // assemble the query
        WebResource webResource = getWebResource();

        MultivaluedMapImpl map = new MultivaluedMapImpl();
        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);
        if (expand != null && !expand.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String ex : expand) {
                if (sb.length() > 0) sb.append(PARAM_VALUE_SEPARATOR);
                sb.append(ex);
            }
            map.putSingle(PARAM_EXPAND, sb.toString());
        }
        webResource = webResource.queryParams(map);
        webResource = webResource.path(PATH_PLUGINSBYPLUGINKEY);


        Form form = new Form();
        if (pluginKeys != null && !pluginKeys.isEmpty())
        {
            for (String pluginKey : pluginKeys) {
                form.add(PARAM_PLUGINKEYS, pluginKey);
            }
        }

        // make the call and convert to a proper list
        ClientResponse response = webResource.post(ClientResponse.class, form);

        // this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Plugin>();
        return listWrapper.getList();
    }

    public Long countPluginsByCategory(String categoryId) {

        //assemble the query
        WebResource webResource = getWebResource();

        webResource = webResource.path(PATH_PLUGINSBYCATEGORYCOUNT + "/" + categoryId);

        //make the call
        ClientResponse response = webResource.type(CONTENT_XML).get(ClientResponse.class);
        String total = (String)getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public List<Plugin> searchPlugins(String categoryKey, String query, Integer max, Integer offset, List<String> expand) {

        String categoryKeyPath = (categoryKey == null) ? PATHCOMPONENT_SEARCH_ALL_PRODUCTS : categoryKey;

        //assemble the query
        WebResource webResource = getWebResource();

        MultivaluedMapImpl map = new MultivaluedMapImpl();
        map.putSingle(PARAM_QUERY, query);
        if (max != null) map.putSingle(PARAM_MAX, max);
        if (offset != null) map.putSingle(PARAM_OFFSET, offset);
        if (expand != null && !expand.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String ex : expand) {
                if (sb.length() > 0) sb.append(PARAM_VALUE_SEPARATOR);
                sb.append(ex);
            }
            map.putSingle(PARAM_EXPAND, sb.toString());
        }
        webResource = webResource.queryParams(map);
        webResource = webResource.path(PATH_SEARCH + "/" + categoryKeyPath);

        //make the call and convert to a proper list
        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Plugin>();
        return listWrapper.getList();
    }

    public Long searchPluginsCount(String categoryKey, String query) {

        String categoryKeyPath = (categoryKey == null) ? PATHCOMPONENT_SEARCH_ALL_PRODUCTS : categoryKey;

        //assemble the query
        WebResource webResource = getWebResource();

        MultivaluedMapImpl map = new MultivaluedMapImpl();
        map.putSingle(PARAM_QUERY, query);

        webResource = webResource.queryParams(map);
        webResource = webResource.path(PATH_SEARCHCOUNT + "/" + categoryKeyPath);

        //make the call
        ClientResponse response = webResource.type(CONTENT_XML).get(ClientResponse.class);
        String total = (String)getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public void reindexPlugins() {
        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_SEARCHINDEX);
        ClientResponse response = buildWebResource(webResource).get(ClientResponse.class);
        getEntityFromResponse(response, null);
    }

    public List getNumberOfPlugins(String product, Date start, Date end, String period, String countVersions,
        String cumulative)
    {
        if (product == null || start == null || end == null || period == null) {
            throw new IllegalArgumentException("Product, Start Date, End Date, and Period cannot be null");
        }

        final DateFormat df = new SimpleDateFormat(FORMAT_AGGREGATE_DATE);

        //assemble the query
        WebResource webResource = getWebResource();

        webResource = webResource.path(PATH_NUMBER + "/" + product + "/" + df.format(start) + "/" + df.format(end) + "/" + period + "/" +
            countVersions + "/" + cumulative);

        //make the call and convert to a proper list
        ClientResponse response = buildWebResource(webResource).get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Download>();
        return listWrapper.getList();

    }
}
