package com.atlassian.plugins.client.service.plugin;

import com.atlassian.plugins.PacException;
import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.Status;
import com.atlassian.plugins.domain.model.plugin.Icon;
import com.atlassian.plugins.service.plugin.IconService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.io.InputStream;

public class IconServiceClientImpl extends AbstractRestServiceClient<Icon> implements IconService {

    protected Class<Icon> getEntity() {
        return Icon.class;
    }

    protected String getPath() {
        return PATH;
    }

    public InputStream fetch(String id) {
        throw new UnsupportedOperationException("Fetch should be called directly, not through the client");
    }

    public void upload(InputStream in, Icon icon) {

        // Objects being sent back to the server needs to be expanded so that all the fields are encoded in the XML
        icon.setExpanded(true);

        //first, create or update the icon
        if (icon.getId() == null) {
            String id = create(icon);
            icon.setId(id);
        } else {
            update(icon.getId(), icon);
        }

        //next, create or update the attachment
        String boundary = "boundary_" + icon.getId() + "_" + System.currentTimeMillis();

        WebResource.Builder webResource = buildWebResource(getWebResource().path("/" + icon.getId() + PATH_UPLOAD));
        webResource = webResource.type("multipart/mixed;boundary=\"" + boundary + "\"");

        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.field("file", in, MediaType.APPLICATION_OCTET_STREAM_TYPE);

        ClientResponse response = webResource.post(ClientResponse.class, multiPart);
        if (response.getStatus() == Response.Status.CREATED.getStatusCode()) return;

        //this will handle 500s and 401s
        Status status = (Status) getEntityFromResponse(response, Status.class);

        throw new PacException("Unexpected Response: " + response.getStatus(), status);

    }

}
