package com.atlassian.plugins.client.service.plugin;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.plugin.Download;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.plugin.DownloadService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@SuppressWarnings("unchecked")
public class DownloadServiceClientImpl extends AbstractRestServiceClient<Download> implements DownloadService {

    protected Class<Download> getEntity() {
        return Download.class;
    }

    protected String getPath() {
        return PATH;
    }

    public Long totalDownloadsForPlugin(String pluginId) {

        WebResource webResource = getWebResource();

        String path = PATH_TOTALFORPLUGIN + "/" + pluginId;
        webResource = webResource.path(path);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        String total = (String) getEntityFromResponse(response, String.class);
        return new Long(total);

    }

    public Long totalDownloadsForPluginVersion(String pluginVersionId) {

        WebResource webResource = getWebResource();

        String path = PATH_TOTALFORPLUGINVERSION + "/" + pluginVersionId;
        webResource = webResource.path(path);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        String total = (String) getEntityFromResponse(response, String.class);
        return new Long(total);
    }

    public String downloadPluginVersion(String pluginVersionId) {
        throw new UnsupportedOperationException("This method not supported through client");
    }

    public List<Download> getDownloads(String pluginId, String product, Date start, Date end, String period)
    {
        if (pluginId == null || product == null || start == null || end == null || period == null) {
            throw new IllegalArgumentException("Plugin Id, Product, Start Date, End Date, and Period cannot be null");
        }

        final DateFormat df = new SimpleDateFormat(FORMAT_AGGREGATE_DATE);

        //assemble the query
        WebResource webResource = getWebResource();

        webResource = webResource.path(PATH_AGGREGATE + "/" + pluginId + "/" + product + "/" + df.format(start) + "/" + df.format(end) + "/" + period);

        //make the call and convert to a proper list
        ClientResponse response = buildWebResource(webResource).get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Download>();
        return listWrapper.getList();
        
    }
}
