package com.atlassian.plugins.client.service.category;

import com.atlassian.plugins.client.service.AbstractRestServiceClient;
import com.atlassian.plugins.domain.model.category.Category;
import com.atlassian.plugins.domain.model.category.CategoryType;
import com.atlassian.plugins.domain.wrapper.ListWrapper;
import com.atlassian.plugins.service.category.CategoryService;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;

import java.util.ArrayList;
import java.util.List;

public class CategoryServiceClientImpl extends AbstractRestServiceClient<Category> implements CategoryService {

    protected Class<Category> getEntity() {
        return Category.class;
    }

    protected String getPath() {
        return PATH;
    }

    @SuppressWarnings("unchecked")
    public List<Category> findParentCategory(CategoryType type) {
        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDPARENTCATEGORY + "/" + type);

        //make the call and convert to a proper list
        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Category>();
        return listWrapper.getList();
    }

    @SuppressWarnings("unchecked")
    public List<Category> findParentCategories(String categoryId) {
        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDPARENTCATEGORIES + "/" + categoryId);

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Category>();
        return listWrapper.getList();
    }

    @SuppressWarnings("unchecked")
    public List<Category> findChildCategories(String categoryId, Boolean includeInactiveCategories) {
        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDCHILDCATEGORIES + "/" + categoryId);
        webResource = webResource.queryParam("includeInactiveCategories", includeInactiveCategories.toString());

        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Category>();
        return listWrapper.getList();
    }

    @SuppressWarnings("unchecked")
    public List<Category> findCategoryHierarchyWithKeys(List<String> keys) {
        WebResource webResource = getWebResource();
        webResource = webResource.path(PATH_FINDCATEGORYHIERARCHY);

        if (keys != null && !keys.isEmpty()) {
            MultivaluedMapImpl map = new MultivaluedMapImpl();

            StringBuffer sb = new StringBuffer();
            for (String ex : keys) {
                if (sb.length() > 0) sb.append(PARAM_VALUE_SEPARATOR);
                sb.append(ex);
            }
            map.putSingle(PARAM_KEY, sb.toString());

            webResource = webResource.queryParams(map);
        }


        ClientResponse response = webResource.get(ClientResponse.class);

        //this call will handle 401s and 500s
        ListWrapper listWrapper = (ListWrapper) getEntityFromResponse(response, ListWrapper.class);
        if (listWrapper.getList() == null) return new ArrayList<Category>();
        return listWrapper.getList();
    }
}
