package com.atlassian.plugins.less;

import com.atlassian.lesscss.Constants;
import com.atlassian.plugin.elements.ResourceLocation;

import java.net.URI;
import java.net.URISyntaxException;

public class UriUtils {

    private UriUtils() {
        throw new UnsupportedOperationException();
    }

    public static URI resolvePluginUri(String pluginKey, ResourceLocation resourceLocation) {
        return resolvePluginUri(pluginKey, resourceLocation.getLocation());
    }

    public static URI resolvePluginUri(String pluginKey, String location) {
        try {
            return new URI(Constants.SCHEME_PLUGIN, pluginKey, normalizeLocation(location), null);
        } catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static URI resolveUri(String pluginKey, ResourceLocation resourceLocation) {
        URI uri;

        String sourceParam = resourceLocation.getParameter("source");
        if ("webContextStatic".equalsIgnoreCase(sourceParam)) {
            uri = resolveWebStaticUri(resourceLocation);
        } else {
            uri = resolvePluginUri(pluginKey, resourceLocation);
        }

        return uri;
    }

    public static URI resolveWebStaticUri(ResourceLocation resourceLocation) {
        return resolveWebStaticUri(resourceLocation.getLocation());
    }

    public static URI resolveWebStaticUri(String location) {
        try {
            return new URI(Constants.SCHEME_WEB_STATIC, null, normalizeLocation(location), null);
        } catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static String normalizeLocation(String location) {
        if (!location.startsWith("/")) {
            location = "/" + location;
        }

        return location;
    }

}
