package com.atlassian.plugins.less;

import com.atlassian.lesscss.spi.UriResolver;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;

public class UriResolverModuleDescriptor extends AbstractModuleDescriptor<UriResolver> {

    private UriResolver uriResolver;

    public UriResolverModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    public void enabled() {
        super.enabled();
        uriResolver = moduleFactory.createModule(moduleClassName, this);
        if (uriResolver instanceof StateAware) {
            ((StateAware) uriResolver).enabled();
        }
    }

    @Override
    public void disabled() {
        try {
            if (uriResolver instanceof StateAware) {
                ((StateAware) uriResolver).disabled();
            }
        } finally {
            uriResolver = null;
            super.disabled();
        }
    }

    @Override
    public UriResolver getModule() {
        return uriResolver;
    }
}
