package com.atlassian.plugins.less;

import com.atlassian.lesscss.spi.UriResolver;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.AbstractTransformedDownloadableResource;
import com.google.common.io.ByteStreams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;

class PreCompiledLessResource extends AbstractTransformedDownloadableResource {

    private final UriResolver uriResolver;
    private final URI uri;

    public PreCompiledLessResource(DownloadableResource originalResource, UriResolver uriResolver, URI uri) {
        super(originalResource);
        this.uriResolver = uriResolver;
        this.uri = uri;
    }

    @Override
    public void streamResource(OutputStream out) throws DownloadException {
        try (InputStream is = uriResolver.open(uri)) {
            ByteStreams.copy(is, out);
        } catch (IOException e) {
            throw new DownloadException(e);
        }
    }
}
