/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.linkaggregation.jira;

import com.atlassian.jira.exception.GetException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.linkaggregation.AbstractRemoteLinkAggregator;
import com.atlassian.linkaggregation.RemoteLinkAggregation;
import com.atlassian.linkaggregation.RemoteLinkAggregationJsonBean;
import com.atlassian.linkaggregation.RemoteLinkAggregationType;
import com.atlassian.linkaggregation.RemoteLinkAggregationTypeJsonBean;
import com.atlassian.linkaggregation.jira.bean.IssueAggregateJsonBean;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IssuesRemoteLinkAggregator
extends AbstractRemoteLinkAggregator {
    private static final String ENTITY_NAME = "issue";
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authContext;
    private final ApplicationProperties applicationProperties;

    public IssuesRemoteLinkAggregator(RemoteIssueLinkManager remoteIssueLinkManager, IssueManager issueManager, JiraAuthenticationContext authContext, ApplicationProperties applicationProperties) {
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.issueManager = issueManager;
        this.authContext = authContext;
        this.applicationProperties = applicationProperties;
    }

    @Nonnull
    protected Iterable<RemoteLinkAggregation> aggregateForGlobalId(@Nonnull String globalId) {
        if (this.authContext.isLoggedInUser()) {
            final String baseURL = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
            try {
                List remoteIssueLinksByGlobalIds = this.remoteIssueLinkManager.findRemoteIssueLinksByGlobalIds(Collections.singleton(globalId));
                Iterable issueEntities = Iterables.transform((Iterable)remoteIssueLinksByGlobalIds, (Function)new Function<RemoteIssueLink, Jsonable>(){

                    public Jsonable apply(@Nullable RemoteIssueLink input) {
                        return new IssueAggregateJsonBean(baseURL, (Issue)IssuesRemoteLinkAggregator.this.issueManager.getIssueObject(input.getIssueId()));
                    }
                });
                return this.toRemoteLinkAggregations(globalId, issueEntities);
            }
            catch (GetException getException) {
                // empty catch block
            }
        }
        return this.toRemoteLinkAggregations(globalId, Collections.emptyList());
    }

    private Iterable<RemoteLinkAggregation> toRemoteLinkAggregations(String globalId, Iterable<Jsonable> entities) {
        RemoteLinkAggregationJsonBean ag = new RemoteLinkAggregationJsonBean((RemoteLinkAggregationType)new RemoteLinkAggregationTypeJsonBean(ENTITY_NAME), Long.valueOf(this.remoteIssueLinkManager.getTotalRemoteIssueLinkCountByGlobalId(globalId)), entities);
        return Collections.singletonList(ag);
    }
}

