/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.linkaggregation.jira;

import com.atlassian.jira.bc.project.version.remotelink.RemoteVersionLink;
import com.atlassian.jira.bc.project.version.remotelink.RemoteVersionLinkService;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.linkaggregation.AbstractRemoteLinkAggregator;
import com.atlassian.linkaggregation.RemoteLinkAggregation;
import com.atlassian.linkaggregation.RemoteLinkAggregationJsonBean;
import com.atlassian.linkaggregation.RemoteLinkAggregationType;
import com.atlassian.linkaggregation.RemoteLinkAggregationTypeJsonBean;
import com.atlassian.linkaggregation.jira.bean.VersionAggregateJsonBean;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class VersionsRemoteLinkAggregator
extends AbstractRemoteLinkAggregator {
    private static final String ENTITY_NAME = "version";
    private final RemoteVersionLinkService remoteVersionLinkManager;
    private final JiraAuthenticationContext authContext;
    private final ApplicationProperties applicationProperties;

    public VersionsRemoteLinkAggregator(RemoteVersionLinkService remoteVersionLinkManager, JiraAuthenticationContext authContext, ApplicationProperties applicationProperties) {
        this.remoteVersionLinkManager = remoteVersionLinkManager;
        this.authContext = authContext;
        this.applicationProperties = applicationProperties;
    }

    public Iterable<RemoteLinkAggregation> aggregateForGlobalId(String globalId) {
        List remoteVersionLinks = Collections.emptyList();
        RemoteVersionLinkService.RemoteVersionLinkListResult remoteVersionLinksByGlobalId = this.remoteVersionLinkManager.getRemoteVersionLinksByGlobalId(this.authContext.getUser(), globalId);
        if (remoteVersionLinksByGlobalId.isValid()) {
            remoteVersionLinks = remoteVersionLinksByGlobalId.getRemoteVersionLinks();
        }
        return this.toRemoteLinkAggregations(this.remoteVersionLinkManager.getRemoteVersionLinkCountByGlobalId(globalId), remoteVersionLinks);
    }

    private Iterable<RemoteLinkAggregation> toRemoteLinkAggregations(Long totalRemoteVersionLinks, List<RemoteVersionLink> remoteVersionLinks) {
        RemoteLinkAggregationJsonBean ag = new RemoteLinkAggregationJsonBean((RemoteLinkAggregationType)new RemoteLinkAggregationTypeJsonBean(ENTITY_NAME), totalRemoteVersionLinks, this.toJsonBeans(remoteVersionLinks));
        return Collections.singletonList(ag);
    }

    private Iterable<VersionAggregateJsonBean> toJsonBeans(List<RemoteVersionLink> remoteVersionLinks) {
        if (!this.authContext.isLoggedInUser()) {
            return Collections.emptyList();
        }
        final String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        return ImmutableList.copyOf((Iterable)Iterables.transform(remoteVersionLinks, (Function)new Function<RemoteVersionLink, VersionAggregateJsonBean>(){

            public VersionAggregateJsonBean apply(@Nullable RemoteVersionLink remoteVersion) {
                return new VersionAggregateJsonBean(baseUrl, (Version)remoteVersion.getEntity());
            }
        }));
    }
}

