"use strict";

AJS.test.require("com.atlassian.plugins.jira-html5-attach-images:jira-html5-attach-images-resources");

module("JIRA.AttachImagesPlugin.isPasteEvent", {
    pasteEvents: {
        mac: {
            metaKey: true,
            which: 86,
            ctrlKey: false
        },

        pc: {
            metaKey: false,
            which: 86,
            ctrlKey: true
        }
    }
});

["Macintosh", "MacIntel", "MacPPC", "Mac68K"].forEach(function (platform) {
    test("Only ⌘+v should be a paste event on " + platform, function () {
        equal(JIRA.AttachImagesPlugin.isPasteEvent(this.pasteEvents.mac, platform), true);
        equal(JIRA.AttachImagesPlugin.isPasteEvent(this.pasteEvents.pc, platform), false);
    });
});


[
    "OS/2", "Pocket PC", "Windows", "Win16", "Win32", "WinCE",
    "SunOS","SunOS i86pc", "SunOS sun4u",
    "Linux", "Linux i686", "Linux i686 X11", "Linux armv7l", "Linux x86_64 X11"
].forEach(function (platform) {
    test("Only Ctrl+v should be a paste event on " + platform, function () {
        equal(JIRA.AttachImagesPlugin.isPasteEvent(this.pasteEvents.pc, platform), true);
        equal(JIRA.AttachImagesPlugin.isPasteEvent(this.pasteEvents.mac, platform), false);
    });
});
