(function($) {
    var restUrl = AJS.contextPath() + "/rest/helptips/1.0/tips";
    var Manager = {
        dismissedTipIds: [],
        sequences: [],
        loaded: $.Deferred(),
        url: function() { return restUrl; },
        sync: function(verb, data) {
            verb || (verb = "get");
            data || (data = null);
            return $.ajax(this.url(), {
                type: verb,
                context: this,
                dataType: "json",
                contentType: "application/json",
                data: data && JSON.stringify(data),
                processData: false
            }).promise();
        },
        fetch: function() {
            var result = this.sync();
            result.done(function(response) {
                $.merge(this.dismissedTipIds, response);
                this.loaded.resolve();
            });
            return result.promise();
        },
        show: function(showFunction) {
            this.loaded.done(showFunction);
        },
        dismiss: function(tip) {
            var id = tip.attributes.id;
            if (!id) {
                tip._dismissed = true;
            } else {
                this.dismissedTipIds.push(id);
                this.sync("post", {id:id});
            }
        },
        undismiss: function(tip) {
            var id = tip.attributes.id;
            if (!id) {
                tip._dismissed = false;
            } else {
                this.dismissedTipIds.splice($.inArray(id, this.dismissedTipIds), 1);
                this.sync("delete", {id:id});
            }
        },
        isDismissed: function(tip) {
            var id = tip.attributes.id;
            return (id) ? $.inArray(id, this.dismissedTipIds) >= 0 : tip._dismissed;
        },
        /**
         * Clear the list of helptips that would be shown in sequence
         */
        clearSequences: function() {
            this.sequences = [];
        },
        /**
         * Hide all the helptips that would be shown in sequence
         */
        hideSequences: function() {
            _.each(this.sequences, function(helptip) {
                helptip.view.dismiss();
            });
        },
        /**
         * Initiate the rendering of helptips in sequence starting from the first one
         */
        showSequences: function() {
            if (!this._showStarted) {
                var instance = this;
                var index = 0;
                this._showStarted = true;
                $.when(this.loaded).done(function() {
                    //Sort by weight
                    instance.sequences.sort(function(a, b) {
                        return a.attributes.weight - b.attributes.weight;
                    });
                    //Remove any helptips that have already been dismissed
                    instance.sequences = _.filter(instance.sequences, function(dialog) {
                        var shouldShow = _.indexOf(instance.dismissedTipIds, dialog.attributes.id) === -1;
                        if (shouldShow) {
                            dialog.attributes.position = index++;
                        }
                        return shouldShow;
                    });
                    if (instance.sequences.length > 0) {
                        instance.sequences[0].show({force: true});
                    }
                    instance._showStarted = false;
                });
            }
        }
    };

    AJS.HelpTip.Manager = Manager;
    // Load up the user's dismissed tips.
    Manager.fetch();
})(AJS.$);