/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.projectcreate.crud.service;

import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.createcontent.api.services.SpaceBlueprintService;
import com.atlassian.confluence.plugins.createcontent.rest.BlueprintWebItemService;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateBlueprintSpaceRestEntity;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateDialogWebItemEntity;
import com.atlassian.confluence.plugins.createcontent.services.model.BlueprintSpace;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintSpaceEntity;
import com.atlassian.confluence.plugins.projectcreate.crud.exception.CreateSpaceFailureException;
import com.atlassian.confluence.plugins.projectcreate.crud.service.AbstractSpaceCreator;
import com.atlassian.confluence.plugins.projectcreate.crud.service.SpaceCreator;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.DocumentationBean;
import com.atlassian.confluence.util.i18n.DocumentationBeanFactory;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.user.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SoftwareSpaceCreator
extends AbstractSpaceCreator
implements SpaceCreator {
    private final SpaceBlueprintService spaceBlueprintService;
    private I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final BlueprintWebItemService blueprintWebItemService;
    private final DocumentationBean documentationBean;
    private String softwareSpaceBlueprintId;
    private static final String SOFTWARE_SPACE_BLUEPRINT_KEY = "com.atlassian.confluence.plugins.confluence-software-project:sp-space-blueprint";

    public SoftwareSpaceCreator(SpaceService spaceService, SpaceBlueprintService spaceBlueprintService, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, BlueprintWebItemService blueprintWebItemService, DocumentationBeanFactory documentationBeanFactory) {
        super(spaceService);
        this.spaceBlueprintService = spaceBlueprintService;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.blueprintWebItemService = blueprintWebItemService;
        this.documentationBean = documentationBeanFactory.getDocumentationBean();
        this.softwareSpaceBlueprintId = null;
    }

    @Override
    public Space createSpace(ConfluenceUser user, String spaceKey, String spaceName, Map<String, String> context) throws CreateSpaceFailureException {
        String bluePrintId = this.getBluePrintId(user);
        CreateBlueprintSpaceRestEntity entity = new CreateBlueprintSpaceRestEntity(spaceKey, spaceName, "", null, bluePrintId, new HashMap());
        try {
            BlueprintSpace spaceBP = this.spaceBlueprintService.createSpace((CreateBlueprintSpaceEntity)entity, user);
            if (spaceBP == null || spaceBP.getSpace() == null) {
                throw new CreateSpaceFailureException("confluence.projectcreate.space.create.failed");
            }
            return Space.builder().key(spaceBP.getSpace().getKey()).name(spaceBP.getSpace().getName()).build();
        }
        catch (Exception e) {
            throw new CreateSpaceFailureException("confluence.projectcreate.space.create.failed");
        }
    }

    @Override
    public boolean canHandle(ConfluenceUser user, String spaceKey, String spaceName, Map<String, String> context) {
        String projectTemplateModuleKey;
        return context != null && context.get("projectTemplateModuleKey") != null && (projectTemplateModuleKey = context.get("projectTemplateModuleKey")).startsWith("com.pyxis.greenhopper.jira");
    }

    private String getBluePrintId(ConfluenceUser user) throws CreateSpaceFailureException {
        if (this.softwareSpaceBlueprintId != null) {
            return this.softwareSpaceBlueprintId;
        }
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)user));
        List spaceBlueprints = this.blueprintWebItemService.getCreateSpaceWebItems(i18NBean, this.documentationBean, user);
        for (CreateDialogWebItemEntity blueprint : spaceBlueprints) {
            if (!blueprint.getBlueprintModuleCompleteKey().equals(SOFTWARE_SPACE_BLUEPRINT_KEY)) continue;
            this.softwareSpaceBlueprintId = blueprint.getContentBlueprintId().toString();
        }
        if (this.softwareSpaceBlueprintId == null) {
            throw new CreateSpaceFailureException("confluence.projectcreate.space.create.failed");
        }
        return this.softwareSpaceBlueprintId;
    }
}

