/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.token;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.HipChatScope;
import com.atlassian.hipchat.api.HipChatTokenReference;
import com.atlassian.hipchat.api.ResourceError;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.connect.descriptor.ConnectDescriptor;
import com.atlassian.hipchat.api.session.GenerateTokenResult;
import com.atlassian.hipchat.api.session.SessionService;
import com.atlassian.plugins.hipchat.ao.AOHipChatLink;
import com.atlassian.plugins.hipchat.ao.AOHipChatUser;
import com.atlassian.plugins.hipchat.ao.InternalHipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatDarkFeatureService;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.api.link.ConnectDescriptorLoader;
import com.atlassian.plugins.hipchat.descriptor.HipChatConnectDescriptorConstants;
import com.atlassian.plugins.hipchat.link.HipChatAOLinkManager;
import com.atlassian.plugins.hipchat.token.HipChatTokenRefreshService;
import com.atlassian.plugins.hipchat.token.NoSuchTokenReference;
import com.atlassian.plugins.hipchat.token.SimpleHipChatTokenReference;
import com.atlassian.plugins.hipchat.user.HipChatAOUserManager;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.ClientResponse;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHipChatTokenRefreshService
implements HipChatTokenRefreshService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHipChatTokenRefreshService.class);
    private static final String HIPCHAT_TOKEN_IDENTIFIER = "%s(%s)";
    private final HipChatDarkFeatureService hipChatDarkFeatureService;
    @VisibleForTesting
    static final long EXPIRE_TIME_BUFFER_MILLIS = TimeUnit.MINUTES.toMillis(Integer.getInteger("hipchat.token.expire.time.buffer", 10).intValue());
    private final HipChatAOLinkManager hipChatAOLinkManager;
    private final HipChatRoutesProvider routesProvider;
    private final HipChatAOUserManager hipChatAOUserManager;
    private final ActiveObjects activeObjects;
    private final ConnectDescriptorLoader connectDescriptorLoader;

    public DefaultHipChatTokenRefreshService(HipChatAOLinkManager hipChatAOLinkManager, HipChatRoutesProvider routesProvider, HipChatAOUserManager hipChatAOUserManager, HipChatDarkFeatureService hipChatDarkFeatureService, ActiveObjects activeObjects, ConnectDescriptorLoader connectDescriptorLoader) {
        this.hipChatAOLinkManager = hipChatAOLinkManager;
        this.routesProvider = routesProvider;
        this.hipChatAOUserManager = hipChatAOUserManager;
        this.hipChatDarkFeatureService = hipChatDarkFeatureService;
        this.activeObjects = activeObjects;
        this.connectDescriptorLoader = connectDescriptorLoader;
    }

    @Override
    public Option<HipChatTokenReference> refreshablePersonalToken(UserKey userKey) {
        if (userKey == null) {
            return Option.none();
        }
        Option<AOHipChatUser> maybeAOHipChatUser = this.hipChatAOUserManager.getByUserKey(userKey);
        if (maybeAOHipChatUser.isEmpty()) {
            return Option.none();
        }
        AOHipChatUser aoHipChatUser = (AOHipChatUser)maybeAOHipChatUser.get();
        AOHipChatLink existingLink = aoHipChatUser.getHipChatLink();
        SessionService sessionService = this.hipChatAOLinkManager.makeSessionService(existingLink, this.routesProvider.routes(existingLink.getApiUrl(), new NoSuchTokenReference()), userKey);
        return Option.some((Object)new SimpleHipChatTokenReference(new RefreshPersonalToken(userKey, sessionService)));
    }

    @Override
    public HipChatTokenReference refreshableAddonToken(InternalHipChatLink existingLink) {
        SessionService sessionService = this.hipChatAOLinkManager.makeSessionService(existingLink, this.routesProvider.routes(existingLink.getApiUrl(), new NoSuchTokenReference()), null);
        HipChatLinkId linkId = new HipChatLinkId(existingLink.getID());
        RefreshAddonToken addonToken = new RefreshAddonToken(linkId, sessionService);
        return new SimpleHipChatTokenReference(addonToken);
    }

    @Override
    public HipChatTokenReference refreshableSystemUserToken(InternalHipChatLink existingLink) {
        if (!this.hipChatDarkFeatureService.isHipChatSystemUserEnabled()) {
            return new NoSuchTokenReference("System user is not enabled for this server.");
        }
        SessionService sessionService = this.hipChatAOLinkManager.makeSessionService(existingLink, this.routesProvider.routes(existingLink.getApiUrl(), new NoSuchTokenReference()), null);
        HipChatLinkId linkId = new HipChatLinkId(existingLink.getID());
        return new SimpleHipChatTokenReference(new RefreshSystemUserToken(linkId, sessionService));
    }

    @VisibleForTesting
    boolean isExpired(Date tokenExpiryDate) {
        return tokenExpiryDate == null || new DateTime(tokenExpiryDate).minusMillis((int)EXPIRE_TIME_BUFFER_MILLIS).isBeforeNow();
    }

    private AOHipChatLink getAoHipChatLink(HipChatLinkId linkId) {
        Option<AOHipChatLink> maybeLink = this.hipChatAOLinkManager.getLinkById(linkId);
        if (maybeLink.isEmpty()) {
            throw new IllegalArgumentException("hipchat link with id=" + linkId + " not found.");
        }
        return (AOHipChatLink)maybeLink.get();
    }

    private class RefreshSystemUserToken
    extends BaseRefreshTokenFuture {
        private final HipChatScope[] REQUIRED_SYSTEM_USER_SCOPES;
        private final HipChatLinkId hipChatLinkId;
        private final SessionService sessionService;

        public RefreshSystemUserToken(HipChatLinkId hipChatLinkId, SessionService sessionService) {
            this.REQUIRED_SYSTEM_USER_SCOPES = new HipChatScope[]{HipChatScope.ViewGroup, HipChatScope.SendMessage, HipChatScope.SendNotification};
            this.hipChatLinkId = hipChatLinkId;
            this.sessionService = sessionService;
        }

        @Override
        protected void saveToken(GenerateTokenResult generateTokenResult) {
            DefaultHipChatTokenRefreshService.this.hipChatAOLinkManager.updateSystemUserToken(this.hipChatLinkId, generateTokenResult.getAccessToken(), new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(generateTokenResult.getExpiresIn())));
        }

        @Override
        protected String makeTokenIdentifier() {
            return String.format(DefaultHipChatTokenRefreshService.HIPCHAT_TOKEN_IDENTIFIER, HipChatAPI.TokenType.SystemUserToken.SystemUserToken.name(), this.hipChatLinkId.asEntityId());
        }

        @Override
        protected Promise<Result<GenerateTokenResult>> makeNewToken() {
            Option<AOHipChatLink> existingLink = DefaultHipChatTokenRefreshService.this.hipChatAOLinkManager.getLinkById(this.hipChatLinkId);
            return this.sessionService.generatePasswordToken(((AOHipChatLink)existingLink.get()).getSystemUser(), ((AOHipChatLink)existingLink.get()).getSystemPassword(), this.REQUIRED_SYSTEM_USER_SCOPES);
        }

        @Override
        protected void deleteToken() {
        }

        @Override
        protected Option<String> tryGetExistingToken() {
            return (Option)DefaultHipChatTokenRefreshService.this.activeObjects.executeInTransaction(() -> DefaultHipChatTokenRefreshService.this.hipChatAOLinkManager.getLinkById(this.hipChatLinkId).filter(input -> !DefaultHipChatTokenRefreshService.this.isExpired(input.getSystemTokenExpiry())).map(input -> input.getSystemUserToken()));
        }
    }

    private class RefreshAddonToken
    extends BaseRefreshTokenFuture {
        private final SessionService sessionService;
        private final HipChatLinkId hipChatLinkId;

        public RefreshAddonToken(HipChatLinkId hipChatLinkId, SessionService sessionService) {
            this.hipChatLinkId = hipChatLinkId;
            this.sessionService = sessionService;
        }

        @Override
        protected void saveToken(GenerateTokenResult generateTokenResult) {
            DefaultHipChatTokenRefreshService.this.hipChatAOLinkManager.updateAddonToken(this.hipChatLinkId, generateTokenResult.getAccessToken(), new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(generateTokenResult.getExpiresIn())));
        }

        @Override
        protected String makeTokenIdentifier() {
            return String.format(DefaultHipChatTokenRefreshService.HIPCHAT_TOKEN_IDENTIFIER, HipChatAPI.TokenType.AddonToken.AddonToken.name(), this.hipChatLinkId.asEntityId());
        }

        @Override
        protected Promise<Result<GenerateTokenResult>> makeNewToken() {
            Set<HipChatScope> scopesSet = this.getScopes();
            HipChatScope[] scopes = scopesSet.toArray(HipChatScope.EMPTY_SCOPES_ARRAY);
            return this.sessionService.generateClientCredentialsToken(scopes);
        }

        private Set<HipChatScope> getScopes() {
            Option<ConnectDescriptor> connectDescriptorOption = DefaultHipChatTokenRefreshService.this.connectDescriptorLoader.loadConnectDescriptor(this.hipChatLinkId);
            if (connectDescriptorOption.isDefined()) {
                ConnectDescriptor connectDescriptor = (ConnectDescriptor)connectDescriptorOption.get();
                Set<HipChatScope> scopes = connectDescriptor.getScopes();
                return scopes;
            }
            return HipChatConnectDescriptorConstants.FALLBACK_SCOPES_WHERE_LINK_EXISTS_WITHOUT_DESCRIPTOR;
        }

        @Override
        protected void deleteToken() {
        }

        @Override
        protected Option<String> tryGetExistingToken() {
            return (Option)DefaultHipChatTokenRefreshService.this.activeObjects.executeInTransaction(() -> DefaultHipChatTokenRefreshService.this.hipChatAOLinkManager.getLinkById(this.hipChatLinkId).filter(input -> !DefaultHipChatTokenRefreshService.this.isExpired(input.getAddonTokenExpiry())).map(input -> input.getToken()));
        }
    }

    private class RefreshPersonalToken
    extends BaseRefreshTokenFuture {
        private final SessionService sessionService;
        private final UserKey userKey;

        public RefreshPersonalToken(UserKey userKey, SessionService sessionService) {
            this.userKey = userKey;
            this.sessionService = sessionService;
        }

        @Override
        protected void deleteToken() {
            DefaultHipChatTokenRefreshService.this.hipChatAOUserManager.delete((AOHipChatUser)DefaultHipChatTokenRefreshService.this.hipChatAOUserManager.getByUserKey(this.userKey).get());
        }

        @Override
        protected Option<String> tryGetExistingToken() {
            return (Option)DefaultHipChatTokenRefreshService.this.activeObjects.executeInTransaction(() -> DefaultHipChatTokenRefreshService.this.hipChatAOUserManager.getByUserKey(this.userKey).filter(input -> !DefaultHipChatTokenRefreshService.this.isExpired(input.getUserTokenExpiry())).map(input -> input.getUserToken()));
        }

        @Override
        protected void saveToken(GenerateTokenResult generateTokenResult) {
            DefaultHipChatTokenRefreshService.this.hipChatAOUserManager.updatePersonalToken((AOHipChatUser)DefaultHipChatTokenRefreshService.this.hipChatAOUserManager.getByUserKey(this.userKey).get(), generateTokenResult);
        }

        @Override
        protected String makeTokenIdentifier() {
            return String.format(DefaultHipChatTokenRefreshService.HIPCHAT_TOKEN_IDENTIFIER, HipChatAPI.TokenType.PersonalToken.PersonalToken.name(), this.userKey.getStringValue());
        }

        @Override
        protected Promise<Result<GenerateTokenResult>> makeNewToken() {
            return this.sessionService.generateRefreshToken(((AOHipChatUser)DefaultHipChatTokenRefreshService.this.hipChatAOUserManager.getByUserKey(this.userKey).get()).getRefreshCode());
        }
    }

    private abstract class BaseRefreshTokenFuture
    implements Supplier<Promise<String>> {
        private BaseRefreshTokenFuture() {
        }

        @Override
        public Promise<String> get() {
            String tokenIdentifier = this.makeTokenIdentifier();
            Option<String> currentToken = this.tryGetExistingToken();
            if (currentToken.isDefined()) {
                LOG.debug("Token with name [{}] has not expired, reusing instead of refreshing", (Object)tokenIdentifier);
                return Promises.promise((Object)currentToken.get());
            }
            LOG.debug("Token with name [{}] has expired, refreshing", (Object)tokenIdentifier);
            return this.makeNewToken().done(result -> {
                if (result.isSuccess()) {
                    LOG.debug("Token with name [{}] refreshed, saving in database", (Object)tokenIdentifier);
                    this.saveToken((GenerateTokenResult)result.success());
                } else {
                    if (result.error().getStatusCode() == ClientResponse.Status.BAD_REQUEST.getStatusCode() || result.error().getStatusCode() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
                        this.deleteToken();
                    }
                    ResourceError error = result.error();
                    Throwable throwable = error.toThrowable();
                    LOG.warn("Token with name [{}] refresh failed with status code [{}]. Error message [{}]. Turn on debug mode to see stack trace.", new Object[]{tokenIdentifier, error.getStatusCode(), throwable.getMessage()});
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("", throwable);
                    }
                }
            }).flatMap(result -> {
                if (result.isSuccess()) {
                    return Promises.promise((Object)((GenerateTokenResult)result.success()).getAccessToken());
                }
                return Promises.rejected((Throwable)result.error().toThrowable());
            });
        }

        protected abstract void deleteToken();

        protected abstract Option<String> tryGetExistingToken();

        protected abstract void saveToken(GenerateTokenResult var1);

        protected abstract String makeTokenIdentifier();

        protected abstract Promise<Result<GenerateTokenResult>> makeNewToken();
    }
}

