/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.link;

import com.atlassian.annotations.Internal;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.HipChatTokenReference;
import com.atlassian.plugins.hipchat.ao.InternalHipChatLink;
import com.atlassian.plugins.hipchat.api.DefaultHipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.api.routes.HipChatAPIFactory;
import com.atlassian.plugins.hipchat.link.HipChatLinkConverter;
import com.atlassian.plugins.hipchat.token.HipChatTokenRefreshService;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.atlassian.fugue.Option;
import java.util.function.Function;

@Internal
public class DefaultHipChatLinkConverter
implements HipChatLinkConverter {
    private final HipChatRoutesProvider routesProvider;
    private final HipChatTokenRefreshService hipChatTokenRefreshService;
    private final HipChatAPIFactory hipChatAPIFactory;
    private final UserManager userManager;

    public DefaultHipChatLinkConverter(HipChatRoutesProvider routesProvider, HipChatTokenRefreshService hipChatTokenRefreshService, HipChatAPIFactory hipChatAPIFactory, UserManager userManager) {
        this.routesProvider = routesProvider;
        this.hipChatTokenRefreshService = hipChatTokenRefreshService;
        this.hipChatAPIFactory = hipChatAPIFactory;
        this.userManager = userManager;
    }

    @Override
    public Function<InternalHipChatLink, HipChatLink> toHipChatLink() {
        return link -> {
            Option personalApiOption;
            Option<HipChatTokenReference> personalTokenOption;
            HipChatTokenReference addonToken = this.hipChatTokenRefreshService.refreshableAddonToken((InternalHipChatLink)link);
            HipChatRoutesProvider.Routes addonRoutes = this.routesProvider.routes(link.getApiUrl(), addonToken);
            HipChatTokenReference systemUserToken = this.hipChatTokenRefreshService.refreshableSystemUserToken((InternalHipChatLink)link);
            HipChatRoutesProvider.Routes systemUserRoutes = this.routesProvider.routes(link.getApiUrl(), systemUserToken);
            HipChatAPI<HipChatAPI.TokenType.AddonToken> addonAPI = this.hipChatAPIFactory.createAPI(HipChatAPI.TokenType.AddonToken.AddonToken, addonRoutes, (InternalHipChatLink)link, null);
            HipChatAPI<HipChatAPI.TokenType.SystemUserToken> systemUserAPI = this.hipChatAPIFactory.createAPI(HipChatAPI.TokenType.SystemUserToken.SystemUserToken, systemUserRoutes, (InternalHipChatLink)link, null);
            UserProfile remoteUser = this.userManager.getRemoteUser();
            Option<HipChatTokenReference> option = personalTokenOption = remoteUser != null ? this.hipChatTokenRefreshService.refreshablePersonalToken(remoteUser.getUserKey()) : Option.none();
            if (personalTokenOption.isDefined()) {
                HipChatRoutesProvider.Routes personalRoutes = this.routesProvider.routes(link.getApiUrl(), (HipChatTokenReference)personalTokenOption.get());
                personalApiOption = Option.some(this.hipChatAPIFactory.createAPI(HipChatAPI.TokenType.PersonalToken.PersonalToken, personalRoutes, (InternalHipChatLink)link, remoteUser.getUserKey()));
            } else {
                personalApiOption = Option.none();
            }
            return new DefaultHipChatLink(new HipChatLinkId(link.getID()), (InternalHipChatLink)link, systemUserAPI, addonAPI, (Option<HipChatAPI<HipChatAPI.TokenType.PersonalToken>>)personalApiOption);
        };
    }
}

