/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.notification;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.MessageFormat;
import com.atlassian.hipchat.api.ResourceError;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.cards.Card;
import com.atlassian.hipchat.api.rooms.MessageBgColor;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.events.HipChatRoomNotFoundEvent;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.api.notification.DefaultHipChatNotificationOptions;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationOptions;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationService;
import com.atlassian.plugins.hipchat.util.LogUtil;
import com.atlassian.sal.api.net.ResponseException;
import com.sun.jersey.api.client.ClientResponse;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultHipChatNotificationService
implements HipChatNotificationService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHipChatNotificationService.class);
    private final HipChatLinkProvider hipchatLinkProvider;
    private final EventPublisher eventPublisher;
    private static ApiProvider<HipChatAPI.TokenType.AddonToken> getAddonApi = HipChatLink::getAddonApi;
    private static ApiProvider<HipChatAPI.TokenType.SystemUserToken> getSystemUserApi = HipChatLink::getSystemUserApi;

    @Autowired
    public DefaultHipChatNotificationService(HipChatLinkProvider hipchatLinkProvider, EventPublisher eventPublisher) {
        this.hipchatLinkProvider = hipchatLinkProvider;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void notifyUser(@Nonnull String toId, @Nonnull String msg) throws ResponseException {
        this.notifyUser(toId, msg, HipChatNotificationOptions.NONE);
    }

    @Override
    public void notifyUser(@Nonnull String toId, @Nonnull String msg, @Nonnull HipChatNotificationOptions options) throws ResponseException {
        this.doNotify(toId, msg, options.getMessageFormat(), options.getBackgroundColor(), options.getCard(), options.getAttachTo(), getSystemUserApi, (toId1, msg1, messageFormat, messageBgColor, card, attachTo, api) -> api.users().sendPrivateMessage(toId1, msg1, messageFormat));
    }

    @Override
    public void notifyRoom(@Nonnull String toId, @Nonnull String msg) throws ResponseException {
        this.notifyRoom(toId, msg, HipChatNotificationOptions.NONE);
    }

    @Override
    public void notifyRoom(@Nonnull String toId, @Nonnull String msg, @Nonnull HipChatNotificationOptions options) throws ResponseException {
        this.doNotify(toId, msg, options.getMessageFormat(), options.getBackgroundColor(), options.getCard(), options.getAttachTo(), getAddonApi, (toId1, msg1, messageFormat, messageBgColor, card, attachTo, api) -> api.rooms().sendMessage(toId1, msg1, messageFormat, messageBgColor.isDefined() ? (MessageBgColor)((Object)((Object)messageBgColor.get())) : MessageBgColor.GRAY, (Card)card.getOrNull(), (String)attachTo.getOrNull(), options.isNotifyingClients()));
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull Option<MessageBgColor> color) throws ResponseException {
        this.notifyRoom(toID, msg, new DefaultHipChatNotificationOptions.DefaultHipChatNotificationOptionsBuilder().setBackgroundColor(color).build());
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull Option<MessageBgColor> color, boolean notifyClients) throws ResponseException {
        this.notifyRoom(toID, msg, new DefaultHipChatNotificationOptions.DefaultHipChatNotificationOptionsBuilder().setBackgroundColor(color).setNotifyingClients(notifyClients).build());
    }

    private void doNotify(String toId, String msg, MessageFormat messageFormat, Option<MessageBgColor> messageBgColor, Option<Card> card, Option<String> attachTo, ApiProvider<? extends HipChatAPI.TokenType> apiProvider, MessageSender messageSender) throws ResponseException {
        block3: {
            HipChatLink link = this.getDefaultHipChatLink();
            try {
                logger.debug("Sending Hipchat notification to {}", (Object)toId);
                Result result = (Result)messageSender.sendMessage(toId, msg, messageFormat, messageBgColor, card, attachTo, (HipChatAPI)apiProvider.apply((HipChatAPI.TokenType)((Object)link))).get();
                if (!result.isError()) break block3;
                ResourceError error = result.error();
                if (error.getStatusCode() == ClientResponse.Status.NOT_FOUND.getStatusCode()) {
                    logger.warn("Error sending notification to {} - {}", (Object)toId, (Object)error.getMessage());
                    this.eventPublisher.publish((Object)new HipChatRoomNotFoundEvent(toId));
                    break block3;
                }
                throw new ResponseException(error.toThrowable());
            }
            catch (Exception e) {
                String message = "Error sending notification to " + toId + " " + e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                LogUtil.log(logger, message, e);
                throw new ResponseException("Something bad happened while sending a message to Hipchat.", (Throwable)e);
            }
        }
    }

    private HipChatLink getDefaultHipChatLink() throws ResponseException {
        logger.debug("Checking for Hipchat links.");
        Option<HipChatLink> link = this.hipchatLinkProvider.getDefaultLink();
        if (!link.isDefined()) {
            logger.error("No hipChat link defined");
            throw new ResponseException("No hipchat link currently configured");
        }
        return (HipChatLink)link.get();
    }

    private static interface MessageSender {
        public Promise<Result<Void>> sendMessage(String var1, String var2, MessageFormat var3, Option<MessageBgColor> var4, Option<Card> var5, Option<String> var6, HipChatAPI<? extends HipChatAPI.TokenType> var7);
    }

    private static interface ApiProvider<T extends HipChatAPI.TokenType>
    extends Function<HipChatLink, HipChatAPI<T>> {
    }
}

