/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.client;

import com.atlassian.plugins.hipchat.api.client.RateLimitStateService;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitMonitoringClientFilter
extends ClientFilter {
    public static final String HIPCHAT_OBSERVE_RATE_LIMIT = "hipchat.observe.rate.limit";
    public static final int MINIMUM_RATE_LIMIT = 20;
    public static final int MAXIMUM_DELAY = 20000;
    private final RateLimitStateService rateLimitStateService;
    private static final Logger logger = LoggerFactory.getLogger(RateLimitMonitoringClientFilter.class);

    public RateLimitMonitoringClientFilter(RateLimitStateService rateLimitStateService) {
        this.rateLimitStateService = rateLimitStateService;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        RateLimitStateService.RateLimitState state = (RateLimitStateService.RateLimitState)this.rateLimitStateService.getRateLimitState().getOrNull();
        if (state != null && state.getRemaining() < 20L) {
            try {
                long delay = Math.max(Math.min(20000L, state.getReset()), 0L);
                if (Boolean.getBoolean(HIPCHAT_OBSERVE_RATE_LIMIT)) {
                    logger.warn("Delaying request to " + cr.getURI() + " for " + (double)delay / 1000.0 + " seconds to avoid rate limiting. (current reset = " + (double)state.getReset() / 1000.0 + ", current remaining = " + state.getRemaining() + ")");
                    Thread.sleep(delay);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        ClientResponse resp = this.getNext().handle(cr);
        this.rateLimitStateService.setRateLimitState(resp);
        return resp;
    }
}

