/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.webhooks;

import com.atlassian.hipchat.api.connect.descriptor.Webhook;
import com.atlassian.hipchat.api.webhooks.WebhookPayload;
import javax.annotation.concurrent.Immutable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class RoomDeleted
extends WebhookPayload {
    private Item item;

    @JsonCreator
    public RoomDeleted(@JsonProperty(value="event") String event, @JsonDeserialize(as=Item.class) @JsonProperty(value="item") Item item, @JsonProperty(value="oauth_client_id") String oauthClientId, @JsonProperty(value="web_hook_id") int webHookId) {
        super(event, oauthClientId, webHookId);
        this.item = item;
    }

    public RoomDeleted(long roomId, String oauthClientId) {
        this(Webhook.EventType.room_deleted.name(), new Item(new Room(roomId, "dummy room name")), oauthClientId, 1);
    }

    @JsonProperty(value="item")
    public Item getItem() {
        return this.item;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Immutable
    public static class Room {
        private long id;
        private String name;

        public Room(@JsonProperty(value="id") long id, @JsonProperty(value="name") String name) {
            this.id = id;
            this.name = name;
        }

        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Immutable
    public static class Item {
        @JsonProperty(value="room")
        private Room room;

        public Item(@JsonDeserialize(as=Room.class) @JsonProperty(value="room") Room room) {
            this.room = room;
        }

        public Room getRoom() {
            return this.room;
        }
    }
}

