/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.addons;

import com.atlassian.annotations.Internal;
import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.ResourceMapper;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.addons.AddonService;
import com.atlassian.hipchat.api.addons.CreateAddonLinkRequest;
import com.atlassian.hipchat.api.addons.CreateAddonLinkResult;
import com.atlassian.hipchat.api.addons.GetAddonResult;
import com.atlassian.hipchat.api.addons.UpdateAddonRequest;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.ws.rs.core.MediaType;

@Internal
public class DefaultAddonService<T extends HipChatAPI.TokenType>
implements AddonService {
    private final Client client;
    private final HipChatRoutesProvider.Routes<T> routes;
    private final ClientResponseMapper mapper;

    public DefaultAddonService(ClientResponseMapper mapper, HipChatRoutesProvider.Routes<T> routes, Client client) {
        this.mapper = mapper;
        this.routes = routes;
        this.client = client;
    }

    @Override
    public Promise<Result<GetAddonResult>> getAddon(String addonId) {
        Preconditions.checkNotNull((Object)addonId);
        return this.routes.getAddon(addonId).flatMap(ResourceMapper.toGetAsyncJsonResource(this.client)).map(this.mapper.to(GetAddonResult.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Void>> updateAddon(String addonId, URI descriptorURI, boolean isEnabled) {
        Preconditions.checkNotNull((Object)addonId, (Object)"Addon id must not be null.");
        Preconditions.checkNotNull((Object)descriptorURI, (Object)"Descriptor uri must not be null.");
        UpdateAddonRequest request = new UpdateAddonRequest(isEnabled, descriptorURI);
        return this.routes.updateAddon(addonId).flatMap(ResourceMapper.toPutAsyncJsonResource(this.client, request, MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<CreateAddonLinkResult>> createAddonLink(int ttl, String target) {
        return this.routes.createAddonLink().flatMap(ResourceMapper.toPostAsyncJsonResource(this.client, new CreateAddonLinkRequest(ttl, target), MediaType.APPLICATION_JSON_TYPE)).map(this.mapper.to(CreateAddonLinkResult.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<ClientResponse> invokeAddonLink(String token) {
        return this.routes.invokeAddonLink(token).flatMap(ResourceMapper.toGetAsync(this.client));
    }
}

