/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api;

import com.atlassian.hipchat.api.CollapsedEntity;
import com.atlassian.hipchat.api.Result;
import com.google.common.util.concurrent.SettableFuture;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.async.ITypeListener;
import com.sun.jersey.api.client.async.TypeListener;
import com.sun.jersey.api.representation.Form;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceMapper.class);

    public static Function<URI, Promise<ClientResponse>> toGetAsyncJsonResource(Client client) {
        return input -> {
            CompletableFuture<ClientResponse> result = new CompletableFuture<ClientResponse>();
            client.asyncResource(input).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ResourceMapper.async(result));
            return ResourceMapper.forFuture(result);
        };
    }

    public static Function<URI, Promise<ClientResponse>> toGetAsync(Client client) {
        return input -> {
            CompletableFuture<ClientResponse> result = new CompletableFuture<ClientResponse>();
            client.asyncResource(input).get(ResourceMapper.async(result));
            return ResourceMapper.forFuture(result);
        };
    }

    public static Function<URI, Promise<ClientResponse>> toConditionalGetAsyncJsonResource(Client client, Option<String> etag) {
        return input -> {
            AsyncWebResource.Builder responseBuilder = client.asyncResource(input).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            if (etag.isDefined()) {
                responseBuilder = (AsyncWebResource.Builder)responseBuilder.header("If-None-Match", etag.get());
            }
            CompletableFuture<ClientResponse> future = new CompletableFuture<ClientResponse>();
            responseBuilder.get(ResourceMapper.async(future));
            return ResourceMapper.forFuture(future);
        };
    }

    public static Function<URI, Promise<ClientResponse>> toDeleteAsyncJsonResource(Client client) {
        return input -> {
            CompletableFuture<ClientResponse> future = new CompletableFuture<ClientResponse>();
            client.asyncResource(input).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(ResourceMapper.async(future));
            return ResourceMapper.forFuture(future);
        };
    }

    public static Function<URI, Promise<ClientResponse>> toPostAsyncJsonResource(Client client, Object data, MediaType sendType) {
        return input -> {
            CompletableFuture<ClientResponse> future = new CompletableFuture<ClientResponse>();
            ((AsyncWebResource.Builder)client.asyncResource(input).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(sendType)).post(ResourceMapper.async(future), data);
            return ResourceMapper.forFuture(future);
        };
    }

    public static Function<URI, Promise<ClientResponse>> toPutAsyncJsonResource(Client client, Object data, MediaType sendType) {
        return input -> {
            CompletableFuture<ClientResponse> future = new CompletableFuture<ClientResponse>();
            ((AsyncWebResource.Builder)client.asyncResource(input).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(sendType)).put(ResourceMapper.async(future), data);
            return ResourceMapper.forFuture(future);
        };
    }

    public static Function<URI, Promise<ClientResponse>> toPostAsyncFormResource(Client client, Form data) {
        return input -> {
            CompletableFuture<ClientResponse> future = new CompletableFuture<ClientResponse>();
            client.asyncResource(input).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).post(ResourceMapper.async(future), (Object)data);
            return ResourceMapper.forFuture(future);
        };
    }

    public static <T> Function<Throwable, Result<T>> handleError() {
        return input -> {
            LOGGER.debug("Unexpected error encountered communicating with Hipchat.", input);
            return Result.error(input);
        };
    }

    public static <T> Function<CollapsedEntity<T>, T> expandAll() {
        return input -> input.expanded();
    }

    public static ITypeListener<ClientResponse> async(final SettableFuture<ClientResponse> future) {
        return new TypeListener<ClientResponse>(ClientResponse.class){

            public void onComplete(Future<ClientResponse> f) throws InterruptedException {
                try {
                    ClientResponse t = f.get();
                    future.set((Object)t);
                }
                catch (ExecutionException e) {
                    future.setException((Throwable)e);
                }
            }
        };
    }

    public static ITypeListener<ClientResponse> async(final CompletableFuture<ClientResponse> future) {
        return new TypeListener<ClientResponse>(ClientResponse.class){

            public void onComplete(Future<ClientResponse> f) throws InterruptedException {
                try {
                    ClientResponse t = f.get();
                    future.complete(t);
                }
                catch (ExecutionException e) {
                    future.completeExceptionally(e);
                }
            }
        };
    }

    public static <T> Promise<T> forFuture(CompletableFuture<T> future) {
        return Promises.forCompletionStage(future);
    }
}

