/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat.guava10.memory;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheException;
import com.atlassian.cache.compat.CacheSettings;
import com.google.common.collect.ComputationException;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

class MemoryCache<K, V>
implements Cache<K, V> {
    private final String name;
    private final ConcurrentMap<K, V> internalCache;

    private MemoryCache(ConcurrentMap<K, V> internalCache, String name) {
        this.internalCache = internalCache;
        this.name = name;
    }

    static <K, V> MemoryCache<K, V> create(ConcurrentMap<K, V> internalCache, String name, CacheSettings settings) {
        return new MemoryCache<K, V>(internalCache, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<K> getKeys() {
        try {
            return this.internalCache.keySet();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void put(K key, V value) {
        try {
            this.internalCache.put(key, value);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public V get(K key) {
        try {
            return this.internalCache.get(key);
        }
        catch (ComputationException e) {
            throw new CacheException(e.getCause());
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void remove(K key) {
        try {
            this.internalCache.remove(key);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public void removeAll() {
        try {
            this.internalCache.clear();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof MemoryCache) {
            MemoryCache otherMemoryCache = (MemoryCache)other;
            if (this.internalCache.equals(otherMemoryCache.internalCache)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 + this.internalCache.hashCode();
    }
}

