/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api;

import com.atlassian.annotations.Internal;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.ResourceError;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.rooms.CollapsedRoom;
import com.atlassian.hipchat.api.rooms.ExpandedRoom;
import com.atlassian.hipchat.api.rooms.MessageBgColor;
import com.atlassian.hipchat.api.users.User;
import com.atlassian.hipchat.api.webhooks.Message;
import com.atlassian.plugins.hipchat.api.HipChatApiService;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.api.HipChatUserId;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationOptions;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationService;
import com.atlassian.plugins.hipchat.api.room.HipChatRoomsProvider;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

@Internal
public class HipChatApiServiceWrapper
implements HipChatApiService {
    public static final String ERROR_NO_LINK = "No hipchat link available";
    private final HipChatNotificationService notificationService;
    private final HipChatRoomsProvider hipChatRoomsProvider;
    private final HipChatLinkProvider hipChatLinkProvider;

    public HipChatApiServiceWrapper(HipChatNotificationService notificationService, HipChatRoomsProvider hipChatRoomsProvider, HipChatLinkProvider hipChatLinkProvider) {
        this.notificationService = notificationService;
        this.hipChatRoomsProvider = hipChatRoomsProvider;
        this.hipChatLinkProvider = hipChatLinkProvider;
    }

    @Override
    public void notifyUser(@Nonnull String toID, @Nonnull String msg) throws ResponseException {
        this.notificationService.notifyUser(toID, msg);
    }

    @Override
    public void notifyUser(@Nonnull String toID, @Nonnull String msg, @Nonnull HipChatNotificationOptions options) throws ResponseException {
        this.notificationService.notifyUser(toID, msg, options);
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg) throws ResponseException {
        this.notificationService.notifyRoom(toID, msg);
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull HipChatNotificationOptions options) throws ResponseException {
        this.notificationService.notifyRoom(toID, msg, options);
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull Option<MessageBgColor> color) throws ResponseException {
        this.notificationService.notifyRoom(toID, msg, color);
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull Option<MessageBgColor> color, boolean notifyClients) throws ResponseException {
        this.notificationService.notifyRoom(toID, msg, color, notifyClients);
    }

    @Override
    public Promise<Result<Message>> getRoomMessage(String roomId, String messageId) {
        Option<HipChatLink> defaultLink = this.hipChatLinkProvider.getDefaultLink();
        if (!defaultLink.isDefined()) {
            return Promises.promise(Result.error(ERROR_NO_LINK));
        }
        return this.hipChatRoomsProvider.getRoomMessage(((HipChatLink)defaultLink.get()).getAddonApi(), roomId, messageId);
    }

    @Override
    public Promise<Map<String, Result<ExpandedRoom>>> expandRoomsForIds(Iterable<String> roomIds) {
        Option<HipChatLink> defaultLink = this.hipChatLinkProvider.getDefaultLink();
        if (!defaultLink.isDefined()) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String roomId : roomIds) {
                builder.put((Object)roomId, Result.error(ERROR_NO_LINK, Response.Status.BAD_REQUEST.getStatusCode()));
            }
            return Promises.promise((Object)builder.build());
        }
        HipChatAPI hipChatToken = this.getPersonalHipChatTokenOrAddonIfNotDefined((HipChatLink)defaultLink.get());
        return this.hipChatRoomsProvider.expandRoomsForIds(hipChatToken, roomIds);
    }

    @Override
    public Option<String> getGroupName() {
        return this.hipChatLinkProvider.getDefaultLink().map(input -> input.getGroupName());
    }

    @Override
    public Option<String> getApiUrl() {
        return this.hipChatLinkProvider.getDefaultLink().map((Function)new Function<HipChatLink, String>(){

            @Override
            public String apply(HipChatLink input) {
                return input.getApiUrl();
            }
        });
    }

    @Override
    public Promise<Result<ExpandedRoom>> createRoom(String name, HipChatUserId owner, Option<String> topic) {
        Option<HipChatLink> defaultLink = this.hipChatLinkProvider.getDefaultLink();
        if (defaultLink.isEmpty()) {
            return null;
        }
        Option<HipChatAPI<HipChatAPI.TokenType.PersonalToken>> personalApiOption = ((HipChatLink)defaultLink.get()).getPersonalApi();
        HipChatAPI tokenHipChatAPI = ((HipChatLink)defaultLink.get()).getAddonApi();
        if (personalApiOption.isDefined()) {
            tokenHipChatAPI = (HipChatAPI)personalApiOption.get();
        }
        return this.hipChatRoomsProvider.createRoom(tokenHipChatAPI, name, owner, topic);
    }

    @Override
    public Promise<Result<Void>> deleteRoom(String roomNameOrId) {
        Option<HipChatLink> defaultLink = this.hipChatLinkProvider.getDefaultLink();
        if (defaultLink.isEmpty()) {
            return null;
        }
        Option<HipChatAPI<HipChatAPI.TokenType.PersonalToken>> personalApiOption = ((HipChatLink)defaultLink.get()).getPersonalApi();
        if (personalApiOption.isEmpty()) {
            return Promises.promise(Result.error("Personal token is necessary to delete a room. Confirm access to your Hipchat account"));
        }
        return this.hipChatRoomsProvider.deleteRoom((HipChatAPI)personalApiOption.get(), roomNameOrId);
    }

    @Override
    public Promise<Result<ExpandedRoom>> getRoom(String roomId) {
        if (this.hipChatLinkProvider.getDefaultLink().isEmpty()) {
            return Promises.promise(Result.error(ERROR_NO_LINK));
        }
        return ((HipChatLink)this.hipChatLinkProvider.getDefaultLink().get()).getAddonApi().rooms().getRoom(roomId);
    }

    @Override
    public Promise<Result<User>> getUser(String userId) {
        return ((HipChatLink)this.hipChatLinkProvider.getDefaultLink().get()).getAddonApi().users().getUser(userId);
    }

    @Override
    public Promise<Result<Boolean>> userExists(String emailAddress) {
        Option<HipChatLink> defaultLink = this.hipChatLinkProvider.getDefaultLink();
        if (!defaultLink.isDefined()) {
            return Promises.promise(Result.error(ERROR_NO_LINK));
        }
        return ((HipChatLink)defaultLink.get()).getAddonApi().users().getUser(emailAddress).map((Function)new Function<Result<User>, Result<Boolean>>(){

            @Override
            public Result<Boolean> apply(Result<User> userResult) {
                return userResult.fold(new Function<ResourceError, Result<Boolean>>(){

                    @Override
                    public Result<Boolean> apply(ResourceError resourceError) {
                        if (resourceError.getStatusCode() == 404) {
                            return Result.success(false);
                        }
                        return Result.error(resourceError);
                    }
                }, new Function<User, Result<Boolean>>(){

                    @Override
                    public Result<Boolean> apply(User user) {
                        return Result.success(true);
                    }
                });
            }
        });
    }

    @Override
    public Option<HipChatLinkId> getHipChatLinkId() {
        return this.hipChatLinkProvider.getDefaultLink().flatMap((Function)new Function<HipChatLink, Option<HipChatLinkId>>(){

            @Override
            public Option<HipChatLinkId> apply(HipChatLink link) {
                return Option.some((Object)link.getId());
            }
        });
    }

    @Override
    public Promise<Result<List<CollapsedRoom>>> getAllPublicRooms() {
        Option<HipChatLink> defaultLink = this.hipChatLinkProvider.getDefaultLink();
        if (!defaultLink.isDefined()) {
            return Promises.promise(Result.error(ERROR_NO_LINK));
        }
        return this.hipChatRoomsProvider.getAllRooms(((HipChatLink)defaultLink.get()).getAddonApi());
    }

    @Override
    public Promise<Result<List<CollapsedRoom>>> getAllRooms() {
        Option<HipChatLink> defaultLink = this.hipChatLinkProvider.getDefaultLink();
        if (!defaultLink.isDefined()) {
            return Promises.promise(Result.error(ERROR_NO_LINK));
        }
        Option<HipChatAPI<HipChatAPI.TokenType.PersonalToken>> personalApiOption = ((HipChatLink)defaultLink.get()).getPersonalApi();
        if (personalApiOption.isDefined()) {
            return this.hipChatRoomsProvider.getAllRooms((HipChatAPI)personalApiOption.get(), true);
        }
        return this.hipChatRoomsProvider.getAllRooms(((HipChatLink)defaultLink.get()).getAddonApi());
    }

    private HipChatAPI getPersonalHipChatTokenOrAddonIfNotDefined(HipChatLink hipChatLink) {
        return hipChatLink.getPersonalApi().isDefined() ? (HipChatAPI)hipChatLink.getPersonalApi().get() : hipChatLink.getAddonApi();
    }
}

